/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.listener;

import org.apache.commons.lang.StringUtils;
import org.jboss.test.selenium.encapsulated.FrameLocator;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.utils.testng.TestInfo;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class SeleniumLoggingTestListener
extends TestListenerAdapter {
    public void onTestStart(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestFailure(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestSuccess(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.logStatus(result);
    }

    private void logStatus(ITestResult result) {
        String hashes = "##########";
        String methodName = TestInfo.getMethodName(result);
        String status = TestInfo.STATUSES.get(result.getStatus());
        String message = String.format("%s %s: %s %s", "##########", status.toUpperCase(), methodName, "##########");
        String line = StringUtils.repeat((String)"#", (int)message.length());
        if (AjaxSelenium.getCurrentSelenium() != null) {
            JavaScript eval = JavaScript.js(String.format("/*\n%s\n%s\n%s\n*/", line, message, line));
            try {
                AjaxSelenium.getCurrentSelenium().selectFrame(new FrameLocator("relative=top"));
                AjaxSelenium.getCurrentSelenium().getEval(eval);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

