/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.ajax;

import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.DefaultWaiting;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.ajax.JavaScriptRetriever;

public class AjaxWaiting
extends DefaultWaiting<AjaxWaiting> {
    public void until(JavaScriptCondition condition) {
        AjaxSelenium.getCurrentSelenium().waitForCondition(condition.getJavaScriptCondition(), this.getTimeout());
    }

    public <T> void waitForChange(T oldValue, JavaScriptRetriever<T> retrieve) {
        JavaScript waitCondition = JavaScript.js(SimplifiedFormat.format("{0} != '{1}'", retrieve.getJavaScriptRetrieve().getAsString(), oldValue));
        AjaxSelenium.getCurrentSelenium().waitForCondition(waitCondition, this.getTimeout());
    }

    public <T> T waitForChangeAndReturn(T oldValue, JavaScriptRetriever<T> retrieve) {
        String oldValueString = retrieve.getConvertor().forwardConversion(oldValue);
        JavaScript waitingRetriever = JavaScript.js(SimplifiedFormat.format("selenium.waitForCondition({0} != '{1}'); {0}", retrieve.getJavaScriptRetrieve().getAsString(), oldValueString));
        String retrieved = AjaxSelenium.getCurrentSelenium().getEval(waitingRetriever);
        return retrieve.getConvertor().backwardConversion(retrieved);
    }
}

