/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.retrievers;

import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptRetriever;
import org.jboss.test.selenium.waiting.conversion.Convertor;
import org.jboss.test.selenium.waiting.conversion.PassOnConvertor;
import org.jboss.test.selenium.waiting.selenium.SeleniumRetriever;

public class TextRetriever
implements SeleniumRetriever<String>,
JavaScriptRetriever<String> {
    ElementLocator elementLocator;

    protected TextRetriever() {
    }

    @Override
    public String retrieve() {
        Validate.notNull((Object)this.elementLocator);
        return AjaxSelenium.getCurrentSelenium().getText(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptRetrieve() {
        return JavaScript.js(SimplifiedFormat.format("selenium.getText('{0}')", this.elementLocator.getAsString()));
    }

    public static TextRetriever getInstance() {
        return new TextRetriever();
    }

    public TextRetriever locator(ElementLocator elementLocator) {
        Validate.notNull((Object)elementLocator);
        TextRetriever copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private TextRetriever copy() {
        TextRetriever copy = new TextRetriever();
        copy.elementLocator = this.elementLocator;
        return copy;
    }

    @Override
    public Convertor<String, String> getConvertor() {
        return new PassOnConvertor<String>();
    }
}

