/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.guard.request;

import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.guard.request.RequestTypeGuard;
import org.jboss.test.selenium.request.RequestType;

public final class RequestTypeGuardFactory {
    private RequestTypeGuardFactory() {
    }

    private static AjaxSelenium guard(AjaxSelenium selenium, RequestType requestExpected, boolean interlayed) {
        AjaxSelenium copy;
        try {
            copy = selenium.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        copy.getInterceptionProxy().unregisterInterceptorType(RequestTypeGuard.class);
        copy.getInterceptionProxy().registerInterceptor(new RequestTypeGuard(requestExpected, interlayed));
        return copy;
    }

    public static AjaxSelenium guardXhr(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.XHR, false);
    }

    public static AjaxSelenium guardHttp(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.HTTP, false);
    }

    public static AjaxSelenium guardNoRequest(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.NONE, false);
    }

    public static AjaxSelenium waitXhr(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.XHR, true);
    }

    public static AjaxSelenium waitHttp(AjaxSelenium selenium) {
        return RequestTypeGuardFactory.guard(selenium, RequestType.HTTP, true);
    }
}

