/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.AttributeLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class AttributeEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private AttributeLocator attributeLocator;
    private String value;

    protected AttributeEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull((Object)this.attributeLocator);
        Validate.notNull((Object)this.value);
        return this.selenium.getAttribute(this.attributeLocator).equals(this.value);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedElementLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAssociatedElement().getAsString());
        String escapedAttributeLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAsString());
        String escapedValue = StringEscapeUtils.escapeJavaScript((String)this.value);
        return JavaScript.js(SimplifiedFormat.format("selenium.isElementPresent('{0}') && (selenium.getAttribute('{1}') == '{2}')", escapedElementLocator, escapedAttributeLocator, escapedValue));
    }

    public static AttributeEquals getInstance() {
        return new AttributeEquals();
    }

    public AttributeEquals locator(AttributeLocator attributeLocator) {
        Validate.notNull((Object)attributeLocator);
        AttributeEquals copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    public AttributeEquals text(String value) {
        Validate.notNull((Object)value);
        AttributeEquals copy = this.copy();
        copy.value = value;
        return copy;
    }

    private AttributeEquals copy() {
        AttributeEquals copy = new AttributeEquals();
        copy.attributeLocator = this.attributeLocator;
        copy.value = this.value;
        return copy;
    }
}

