/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.selenium.SeleniumCondition;

public class TextEquals
implements SeleniumCondition,
JavaScriptCondition {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private ElementLocator elementLocator;
    private String text;

    protected TextEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull((Object)this.elementLocator);
        Validate.notNull((Object)this.text);
        return this.selenium.getText(this.elementLocator).equals(this.text);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.getAsString());
        String escapedText = StringEscapeUtils.escapeJavaScript((String)this.text);
        return JavaScript.js(SimplifiedFormat.format("selenium.isElementPresent('{0}') && (selenium.getText('{0}') == '{1}')", escapedLocator, escapedText));
    }

    public static TextEquals getInstance() {
        return new TextEquals();
    }

    public TextEquals locator(ElementLocator elementLocator) {
        Validate.notNull((Object)elementLocator);
        TextEquals copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    public TextEquals text(String text) {
        Validate.notNull((Object)text);
        TextEquals copy = this.copy();
        copy.text = text;
        return copy;
    }

    private TextEquals copy() {
        TextEquals copy = new TextEquals();
        copy.elementLocator = this.elementLocator;
        copy.text = this.text;
        return copy;
    }
}

