/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.ajax;

import com.thoughtworks.selenium.SeleniumException;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;
import org.jboss.test.selenium.waiting.DefaultWaiting;
import org.jboss.test.selenium.waiting.ajax.JavaScriptCondition;
import org.jboss.test.selenium.waiting.ajax.JavaScriptRetriever;

public class AjaxWaiting
extends DefaultWaiting<AjaxWaiting> {
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();

    public void until(JavaScriptCondition condition) {
        this.waitExpectingTimeout(condition.getJavaScriptCondition());
    }

    public <T> void waitForChange(T oldValue, JavaScriptRetriever<T> retriever) {
        JavaScript condition = this.prepareCondition(oldValue, retriever);
        this.waitExpectingTimeout(condition);
    }

    public <T> void waitForChange(JavaScriptRetriever<T> retriever) {
        Object retrieved = this.waitForChangeAndReturn(retriever.getValue(), retriever);
        retriever.setValue(retrieved);
    }

    public <T> T waitForChangeAndReturn(T oldValue, JavaScriptRetriever<T> retriever) {
        JavaScript script = retriever.getJavaScriptRetrieve();
        JavaScript condition = this.prepareCondition(oldValue, retriever);
        this.waitExpectingTimeout(condition);
        String retrieved = this.selenium.getEval(script);
        T converted = retriever.getConvertor().backwardConversion(retrieved);
        return converted;
    }

    public <T> T waitForChangeAndReturn(JavaScriptRetriever<T> retriever) {
        Object retrieved = this.waitForChangeAndReturn(retriever.getValue(), retriever);
        retriever.setValue(retrieved);
        return retrieved;
    }

    private <T> JavaScript prepareCondition(T oldValue, JavaScriptRetriever<T> retriever) {
        String scriptString = retriever.getJavaScriptRetrieve().getAsString();
        String oldValueString = retriever.getConvertor().forwardConversion(oldValue);
        return JavaScript.js(SimplifiedFormat.format("{0} != '{1}'", scriptString, oldValueString));
    }

    private void waitExpectingTimeout(JavaScript condition) {
        try {
            this.selenium.waitForCondition(condition, this.getTimeout());
        }
        catch (SeleniumException e) {
            if (this.isTimeoutException(e)) {
                this.fail();
            }
            throw e;
        }
    }

    private boolean isTimeoutException(SeleniumException e) {
        return e.getMessage().startsWith("Timed out after");
    }
}

