/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.encapsulated;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class JavaScript {
    String javaScript;

    public JavaScript(String javaScript) {
        this.javaScript = javaScript;
    }

    public static JavaScript js(String javaScript) {
        return new JavaScript(javaScript);
    }

    public String getAsString() {
        return this.javaScript;
    }

    public String toString() {
        return this.getAsString();
    }

    public JavaScript join(JavaScript javaScriptToJoin) {
        return JavaScript.js(this.javaScript + '\n' + javaScriptToJoin.javaScript);
    }

    public JavaScript append(String javaScriptPartToAppend) {
        return JavaScript.js(this.javaScript + javaScriptPartToAppend);
    }

    public String getIdentification() {
        return "richfaces-selenium-script-id" + this.javaScript.hashCode();
    }

    public static JavaScript fromFile(File sourceFile) {
        String sourceCode;
        try {
            sourceCode = IOUtils.toString((Reader)new FileReader(sourceFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(SimplifiedFormat.format("Unable to find JavaScript source file '{0}'", sourceFile), e);
        }
        catch (IOException e) {
            throw new RuntimeException(SimplifiedFormat.format("Unable to load JavaScript from file '{0}'", sourceFile), e);
        }
        return JavaScript.js(sourceCode);
    }

    public static JavaScript fromResource(String resourceName) {
        String sourceCode;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(resourceName);
        try {
            sourceCode = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(SimplifiedFormat.format("Unable to load JavaScript from resource with name '{0}'", resourceName), e);
        }
        return JavaScript.js(sourceCode);
    }

    public JavaScript parametrize(Object ... parameters) {
        return JavaScript.js(SimplifiedFormat.format(this.javaScript, parameters));
    }
}

