/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class ExtendedSelenium
extends DefaultSelenium {
    public ExtendedSelenium(CommandProcessor commandProcessor) {
        super(commandProcessor);
    }

    public void open(String url) {
        this.commandProcessor.doCommand("open", new String[]{url, "true"});
    }

    public String getStyle(String locator, String property) {
        return this.commandProcessor.getString("getStyle", new String[]{locator, property});
    }

    public void scrollIntoView(String locator, String alignToTop) {
        this.commandProcessor.doCommand("doScrollIntoView", new String[]{locator, alignToTop});
    }

    public void mouseOverAt(String locator, String coordString) {
        this.commandProcessor.doCommand("doMouseOverAt", new String[]{locator, coordString});
    }

    public boolean isDisplayed(String locator) {
        try {
            return !this.getStyle(locator, "display").contains("none");
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean belongsClass(String locator, String className) {
        Validate.notNull((Object)className);
        Validate.notNull((Object)locator);
        String classLocator = SimplifiedFormat.format("{0}@class", locator);
        String classNames = this.getAttribute(classLocator);
        String regex = SimplifiedFormat.format("(?:^|.*\\s){0}(?:$|\\s.*)", className);
        return classNames.matches(regex);
    }

    public boolean isAttributePresent(String elementLocator, String attributeName) {
        return this.commandProcessor.getBoolean("isAttributePresent", new String[]{elementLocator, attributeName});
    }

    public Number getJQueryCount(String jqueryLocator) {
        return this.commandProcessor.getNumber("getJQueryCount", new String[]{jqueryLocator});
    }

    public void doCommand(String command, String param1, String param2) {
        String[] array = new String[]{param1, param2};
        if (param2 == null) {
            array = new String[]{param1};
        }
        this.commandProcessor.doCommand(command, array);
    }
}

