/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework;

import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.jboss.test.selenium.css.CssProperty;
import org.jboss.test.selenium.framework.ExtendedSelenium;
import org.jboss.test.selenium.framework.ExtendedTypedSelenium;
import org.jboss.test.selenium.framework.TypedSeleniumImpl;
import org.jboss.test.selenium.geometry.Point;
import org.jboss.test.selenium.locator.AttributeLocator;
import org.jboss.test.selenium.locator.ElementLocationStrategy;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.locator.IterableLocator;

public class ExtendedTypedSeleniumImpl
extends TypedSeleniumImpl
implements ExtendedTypedSelenium {
    private boolean started = false;
    private boolean networkTrafficCapturingEnabled = false;

    protected ExtendedSelenium getExtendedSelenium() {
        if (this.selenium instanceof ExtendedSelenium) {
            return (ExtendedSelenium)this.selenium;
        }
        throw new UnsupportedOperationException("Assigned Selenium isn't instance of ExtendedSelenium");
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        LinkedList<String> parameters = new LinkedList<String>();
        if (this.networkTrafficCapturingEnabled) {
            parameters.add("captureNetworkTraffic=true");
        }
        this.selenium.start(StringUtils.join(parameters, (String)","));
        this.started = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.started = false;
    }

    @Override
    public void enableNetworkTrafficCapturing(boolean networkTrafficCapturingEnabled) {
        this.networkTrafficCapturingEnabled = networkTrafficCapturingEnabled;
    }

    @Override
    public boolean isNetworkTrafficCapturingEnabled() {
        return this.networkTrafficCapturingEnabled;
    }

    @Override
    public String getStyle(ElementLocator<?> elementLocator, String property) {
        return this.getExtendedSelenium().getStyle(elementLocator.getAsString(), property);
    }

    @Override
    public String getStyle(ElementLocator<?> elementLocator, CssProperty property) {
        return this.getExtendedSelenium().getStyle(elementLocator.getAsString(), property.getPropertyName());
    }

    @Override
    public void scrollIntoView(ElementLocator<?> elementLocator, boolean alignToTop) {
        this.getExtendedSelenium().scrollIntoView(elementLocator.getAsString(), String.valueOf(alignToTop));
    }

    @Override
    public void mouseOverAt(ElementLocator<?> elementLocator, Point point) {
        this.getExtendedSelenium().mouseOverAt(elementLocator.getAsString(), point.getCoords());
    }

    @Override
    public boolean isDisplayed(ElementLocator<?> elementLocator) {
        return this.getExtendedSelenium().isDisplayed(elementLocator.getAsString());
    }

    @Override
    public boolean belongsClass(ElementLocator<?> elementLocator, String className) {
        return this.getExtendedSelenium().belongsClass(elementLocator.getAsString(), className);
    }

    @Override
    public boolean isAttributePresent(AttributeLocator<?> attributeLocator) {
        String elementLocator = attributeLocator.getAssociatedElement().getAsString();
        String attributeName = attributeLocator.getAttribute().getAttributeName();
        return this.getExtendedSelenium().isAttributePresent(elementLocator, attributeName);
    }

    @Override
    public int getCount(IterableLocator<?> locator) {
        if (locator.getLocationStrategy() == ElementLocationStrategy.JQUERY) {
            return this.getExtendedSelenium().getJQueryCount(locator.getRawLocator()).intValue();
        }
        try {
            return super.getCount(locator);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Only JQuery and XPath locators are supported for counting");
        }
    }

    @Override
    public void check(ElementLocator<?> locator, boolean checked) {
        if (checked) {
            this.check(locator);
        } else {
            this.uncheck(locator);
        }
    }

    @Override
    public void doCommand(String command, String param1, String param2) {
        this.getExtendedSelenium().doCommand(command, param1, param2);
    }
}

