/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.listener;

import com.thoughtworks.selenium.SeleniumException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jboss.test.selenium.SystemProperties;
import org.jboss.test.selenium.encapsulated.NetworkTrafficType;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.utils.testng.TestInfo;
import org.jboss.test.selenium.utils.testng.TestLoggingUtils;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class FailureLoggingTestListener
extends TestListenerAdapter {
    protected File mavenProjectBuildDirectory = SystemProperties.getMavenProjectBuildDirectory();
    protected File failuresOutputDir = new File(this.mavenProjectBuildDirectory, "failures");
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();

    public void onStart(ITestContext testContext) {
        try {
            FileUtils.forceMkdir((File)this.failuresOutputDir);
            FileUtils.cleanDirectory((File)this.failuresOutputDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onConfigurationFailure(ITestResult result) {
        this.onFailure(result);
    }

    public void onTestFailure(ITestResult result) {
        this.onFailure(result);
    }

    protected void onFailure(ITestResult result) {
        String traffic;
        if (!this.selenium.isStarted()) {
            return;
        }
        Throwable throwable = result.getThrowable();
        String stacktrace = null;
        if (throwable != null) {
            stacktrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        }
        String filenameIdentification = this.getFilenameIdentification(result);
        try {
            traffic = this.selenium.captureNetworkTraffic(NetworkTrafficType.PLAIN).getTraffic();
        }
        catch (SeleniumException e) {
            traffic = ExceptionUtils.getFullStackTrace((Throwable)e);
        }
        BufferedImage screenshot = this.selenium.captureEntirePageScreenshot();
        String htmlSource = this.selenium.getHtmlSource();
        File stacktraceOutputFile = new File(this.failuresOutputDir, filenameIdentification + "/stacktrace.txt");
        File imageOutputFile = new File(this.failuresOutputDir, filenameIdentification + "/screenshot.png");
        File trafficOutputFile = new File(this.failuresOutputDir, filenameIdentification + "/network-traffic.txt");
        File htmlSourceOutputFile = new File(this.failuresOutputDir, filenameIdentification + "/html-source.html");
        try {
            File directory = imageOutputFile.getParentFile();
            FileUtils.forceMkdir((File)directory);
            FileUtils.writeStringToFile((File)stacktraceOutputFile, (String)stacktrace);
            ImageIO.write((RenderedImage)screenshot, "PNG", imageOutputFile);
            FileUtils.writeStringToFile((File)trafficOutputFile, (String)traffic);
            FileUtils.writeStringToFile((File)htmlSourceOutputFile, (String)htmlSource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getSeleniumLogIdentification(ITestResult result) {
        String failure = TestInfo.STATUSES.get(result.getStatus()).toUpperCase();
        String started = TestInfo.STATUSES.get(16).toUpperCase();
        String testDescription = TestLoggingUtils.getTestDescription(result);
        testDescription = testDescription.replaceFirst(failure, started);
        testDescription = testDescription.replaceFirst("\\[[^\\]]+\\] ", "");
        return testDescription;
    }

    protected String getFilenameIdentification(ITestResult result) {
        return TestInfo.getClassMethodName(result);
    }
}

