/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.locator;

import org.apache.commons.lang.Validate;
import org.jboss.test.selenium.locator.LocationStrategy;
import org.jboss.test.selenium.locator.Locator;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public abstract class AbstractLocator<T extends Locator<T>>
implements Locator<T> {
    private String locator;

    public AbstractLocator(String locator) {
        Validate.notNull((Object)locator);
        this.locator = locator;
    }

    @Override
    public String getAsString() {
        LocationStrategy locationStrategy = this.getLocationStrategy();
        return SimplifiedFormat.format("{0}={1}", locationStrategy.getStrategyName(), this.getRawLocator());
    }

    @Override
    public String getRawLocator() {
        return this.locator;
    }

    @Override
    public T format(Object ... args) {
        String newLocator = SimplifiedFormat.format(this.locator, args);
        try {
            return (T)((Locator)this.getClass().getConstructor(String.class).newInstance(newLocator));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getAsString();
    }
}

