/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.locator;

import org.jboss.test.selenium.locator.AbstractElementLocator;
import org.jboss.test.selenium.locator.ElementLocationStrategy;
import org.jboss.test.selenium.locator.ExtendedLocator;
import org.jboss.test.selenium.locator.LocatorFactory;
import org.jboss.test.selenium.locator.iteration.ChildElementList;
import org.jboss.test.selenium.locator.iteration.ElementOcurrenceList;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class JQueryLocator
extends AbstractElementLocator<JQueryLocator>
implements ExtendedLocator<JQueryLocator> {
    public JQueryLocator(String jquerySelector) {
        super(jquerySelector);
    }

    @Override
    public ElementLocationStrategy getLocationStrategy() {
        return ElementLocationStrategy.JQUERY;
    }

    @Override
    public JQueryLocator getNthChildElement(int index) {
        return new JQueryLocator(SimplifiedFormat.format("{0}:nth-child({1})", this.getRawLocator(), index));
    }

    @Override
    public JQueryLocator getNthOccurence(int index) {
        return new JQueryLocator(SimplifiedFormat.format("{0}:eq({1})", this.getRawLocator(), index - 1));
    }

    @Override
    public Iterable<JQueryLocator> getAllChildren() {
        return new ChildElementList<JQueryLocator>(this.getChild(LocatorFactory.jq("*")));
    }

    @Override
    public Iterable<JQueryLocator> getChildren(JQueryLocator elementLocator) {
        return new ChildElementList<JQueryLocator>(this.getChild(elementLocator));
    }

    @Override
    public Iterable<JQueryLocator> getDescendants(JQueryLocator elementLocator) {
        return new ElementOcurrenceList<JQueryLocator>(this.getDescendant(elementLocator));
    }

    @Override
    public JQueryLocator getChild(JQueryLocator elementLocator) {
        return new JQueryLocator(SimplifiedFormat.format("{0} > {1}", this.getRawLocator(), elementLocator.getRawLocator()));
    }

    @Override
    public JQueryLocator getDescendant(JQueryLocator elementLocator) {
        return new JQueryLocator(SimplifiedFormat.format("{0} {1}", this.getRawLocator(), elementLocator.getRawLocator()));
    }
}

