/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.actions;

import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.framework.AjaxSeleniumProxy;
import org.jboss.test.selenium.geometry.Dimension;
import org.jboss.test.selenium.geometry.Point;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.waiting.Wait;
import org.jboss.test.selenium.waiting.selenium.SeleniumWaiting;

public class Drag {
    private static final int NUMBER_OF_STEPS = 5;
    private static final int FIRST_STEP = 2;
    private AjaxSelenium selenium = AjaxSeleniumProxy.getInstance();
    private Point currentDelta;
    private Phase currentPhase;
    private ElementLocator<?> itemToDrag;
    private ElementLocator<?> dragIndicator;
    private ElementLocator<?> dropTarget;
    private Point startMove;
    private Point currentPosition;
    private Point endPosition;
    private Point overallMove;
    private Point reposition = new Point(0, 0);
    private Point movement = new Point(0, 0);
    private int numberOfSteps = 5;
    private final SeleniumWaiting wait = (SeleniumWaiting)Wait.waitSelenium().timeout(50L);

    public Drag(ElementLocator<?> itemToDrag, ElementLocator<?> dropTarget) {
        this.currentPhase = Phase.INITIAL;
        this.itemToDrag = itemToDrag;
        this.dropTarget = dropTarget;
        this.setDropTarget(dropTarget);
    }

    public void setDropTarget(ElementLocator<?> dropTarget) {
        switch (this.currentPhase) {
            case INITIAL: {
                this.startMove = new Point(this.selenium.getElementWidth(this.itemToDrag) / 2, this.selenium.getElementHeight(this.itemToDrag) / 2);
                this.currentPosition = this.getCenterOfElement(this.itemToDrag);
                this.endPosition = this.getCenterOfElement(dropTarget);
                this.overallMove = this.endPosition.minus(this.currentPosition);
                return;
            }
            case DROP: {
                throw new IllegalStateException("draggable was already dropped");
            }
            case ENTER: {
                this.selenium.mouseOut(this.dropTarget);
            }
        }
        if (Phase.MOUSE_OUT.before(this.currentPhase)) {
            this.currentPhase = Phase.MOUSE_OUT;
        }
        this.endPosition = this.getCenterOfElement(dropTarget);
        this.overallMove = this.endPosition.minus(this.currentPosition);
        this.reposition = this.currentDelta.minus(this.startMove);
        this.movement = new Point(0, 0);
        this.dropTarget = dropTarget;
    }

    public void setDragIndicator(ElementLocator<?> dragIndicator) {
        this.dragIndicator = dragIndicator;
    }

    public void setNumberOfSteps(int numberOfSteps) {
        this.numberOfSteps = numberOfSteps;
    }

    public void start() {
        this.processUntilPhase(Phase.START);
    }

    public void mouseOut() {
        this.processUntilPhase(Phase.MOUSE_OUT);
    }

    public void move() {
        this.processUntilPhase(Phase.MOVE);
    }

    public void enter() {
        this.processUntilPhase(Phase.ENTER);
    }

    public void drop() {
        this.processUntilPhase(Phase.DROP);
    }

    private void processUntilPhase(Phase requestedPhase) {
        if (requestedPhase.before(this.currentPhase)) {
            throw new IllegalArgumentException("Requested phase (" + (Object)((Object)requestedPhase) + ") is before current phase (" + (Object)((Object)this.currentPhase) + ")");
        }
        while (this.currentPhase.before(requestedPhase)) {
            this.currentPhase = this.currentPhase.next();
            this.executePhase(this.currentPhase);
        }
    }

    private void executePhase(Phase phase) {
        switch (phase) {
            case START: {
                this.currentDelta = this.startMove.plus(new Point(this.overallMove.getX() < 0 ? 2 : -2, this.overallMove.getY() < 0 ? 2 : -2));
                this.selenium.mouseDownAt(this.itemToDrag, new Point(0, 0));
                this.selenium.mouseMoveAt(this.itemToDrag, new Point(2, 2));
                if (this.dragIndicator != null && this.selenium.isElementPresent(this.dragIndicator)) {
                    this.startMove = this.startMove.minus(this.getCentral(this.dragIndicator));
                }
                this.selenium.mouseMoveAt(this.itemToDrag, this.startMove);
                break;
            }
            case MOUSE_OUT: {
                this.selenium.mouseOut(this.itemToDrag);
                break;
            }
            case MOVE: {
                for (int i = 0; i < this.numberOfSteps; ++i) {
                    Point oldMovement = this.movement;
                    this.movement = new Point(this.overallMove.getX() * i / this.numberOfSteps, this.overallMove.getY() * i / this.numberOfSteps);
                    Point movementDelta = this.movement.minus(oldMovement);
                    this.currentDelta = this.reposition.plus(this.startMove).plus(this.movement);
                    this.selenium.mouseMoveAt(this.itemToDrag, this.currentDelta);
                    this.currentPosition = this.currentPosition.plus(movementDelta);
                    this.wait.waitForTimeout();
                }
                break;
            }
            case ENTER: {
                this.currentDelta = this.reposition.plus(this.startMove).plus(this.overallMove);
                this.currentPosition = this.endPosition;
                this.selenium.mouseMoveAt(this.itemToDrag, this.currentDelta);
                this.selenium.mouseOverAt(this.dropTarget, this.currentDelta);
                break;
            }
            case DROP: {
                this.selenium.mouseUp(this.dropTarget);
                break;
            }
        }
    }

    private Point getCentral(ElementLocator<?> element) {
        Dimension dimension = this.selenium.getElementDimension(element);
        Point central = new Point(dimension.getWidth() / 2, dimension.getHeight() / 2);
        return central;
    }

    private Point getCenterOfElement(ElementLocator<?> element) {
        return this.selenium.getElementPosition(element).plus(this.getCentral(element));
    }

    public static enum Phase {
        INITIAL,
        START,
        MOUSE_OUT,
        MOVE,
        ENTER,
        DROP;


        boolean before(Phase phase) {
            return this.compareTo(phase) < 0;
        }

        Phase next() {
            boolean returnNextPhase = false;
            for (Phase phase : Phase.values()) {
                if (returnNextPhase) {
                    return phase;
                }
                if (this != phase) continue;
                returnNextPhase = true;
            }
            return null;
        }
    }
}

