/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.waiting.retrievers;

import org.jboss.test.selenium.waiting.retrievers.RetrievedValueHolder;

public abstract class AbstractRetriever<T>
implements RetrievedValueHolder<T> {
    private ThreadLocal<T> oldValue = new ThreadLocal();

    @Override
    public T getValue() {
        return this.oldValue.get();
    }

    @Override
    public void initializeValue() {
        this.oldValue.set(this.retrieve());
    }

    @Override
    public void setValue(T value) {
        this.oldValue.set(value);
    }

    public boolean isValueChanged() {
        if (this.oldValue.get() == null) {
            return this.retrieve() != null;
        }
        return !this.oldValue.get().equals(this.retrieve());
    }

    public abstract T retrieve();
}

