/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Font;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.seam.pages.xml.model.SeamPagesPreference;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Link;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PageException;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDDirectEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDEditManager;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDEditorLocator;
import org.jboss.tools.seam.ui.pages.editor.figures.ExceptionFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.xpl.CompressNameUtil;

public class ExceptionEditPart
extends PagesEditPart
implements PropertyChangeListener,
EditPartListener,
Adapter,
XModelTreeListener {
    private NodeFigure fig = null;
    private boolean single = true;
    Dimension size;

    public boolean isSingle() {
        return this.single;
    }

    public void doControlUp() {
    }

    public void doControlDown() {
    }

    public void doMouseHover(boolean cf) {
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((PagesDiagramEditPart)this.getParent()).setToFront((EditPart)this);
        }
    }

    public boolean isGroupListenerEnable() {
        return true;
    }

    private void refreshTargetLink(Link link) {
        if (link == null) {
            return;
        }
        ExceptionEditPart gep = (ExceptionEditPart)this.getViewer().getEditPartRegistry().get(link.getToElement());
        if (gep == null) {
            return;
        }
        gep.refreshTargetConnections();
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "EditPart";
            }

            public void getValue(AccessibleControlEvent e) {
            }
        };
    }

    protected List getModelTargetConnections() {
        return this.getExceptionModel().getInputLinks();
    }

    protected List getModelSourceConnections() {
        return this.getExceptionModel().getOutputLinks();
    }

    public void performRequest(Request req) {
        if (req.getType() == "init edit") {
            new ViewIDEditManager((GraphicalEditPart)this, new ViewIDEditorLocator((ExceptionFigure)this.getFigure())).show();
        }
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ViewIDDirectEditPolicy());
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path = event.getModelObject().getPath();
        if (path.equals(SeamPagesPreference.SEAM_PAGES_EDITOR_PATH)) {
            NodeFigure.nodeLabelFont = SeamPagesPreference.getFont((String)SeamPagesPreference.VIEW_PATH_FONT.getValue(), (Font)NodeFigure.nodeLabelFont);
            this.refreshVisuals();
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    protected IFigure createFigure() {
        this.fig = new ExceptionFigure(this.getExceptionModel());
        ((ExceptionFigure)this.fig).setEditPart(this);
        return this.fig;
    }

    public PageException getExceptionModel() {
        return (PageException)this.getModel();
    }

    String getExceptionReadOnlyLabel() {
        if (this.getElementModel() == null || this.getElementModel().getName() == null) {
            return "Unknown Exception";
        }
        return CompressNameUtil.getCompressedName(this.getElementModel().getName());
    }

    @Override
    protected void refreshVisuals() {
        Point loc = this.getExceptionModel().getLocation();
        String text = this.getExceptionReadOnlyLabel();
        int width = this.getIconWidth() + FigureUtilities.getTextExtents((String)text, (Font)NodeFigure.nodeLabelFont).width;
        if (width < this.getMinimumWidth()) {
            width = this.getMinimumWidth();
        }
        this.size = new Dimension(width, this.getVisualHeight());
        this.adjustForGrid(loc);
        Rectangle r = new Rectangle(loc, this.size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    private int getMinimumWidth() {
        return 130;
    }

    private int getVisualHeight() {
        return 21;
    }

    private int getIconWidth() {
        return 30;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        ConnectionAnchor anc = this.getNodeFigure().getConnectionAnchor("1_IN");
        return anc;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        if (this.single) {
            Link link = (Link)connEditPart.getModel();
            int index = this.getExceptionModel().getOutputLinks().indexOf((Object)link);
            return this.getNodeFigure().getConnectionAnchor(String.valueOf(index + 1) + "_OUT");
        }
        return super.getSourceConnectionAnchor(connEditPart);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.single) {
            Point pt = new Point(((DropRequest)request).getLocation());
            return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
        }
        return super.getSourceConnectionAnchor(request);
    }

    protected List getModelChildren() {
        return this.getExceptionModel().getChildren();
    }

    protected void refreshChildren() {
        super.refreshChildren();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((ExceptionEditPart)this.getChildren().get(i)).refresh();
            ++i;
        }
    }

    @Override
    public void activate() {
        if (this.isActive()) {
            return;
        }
        ((Notifier)this.getModel()).eAdapters().add((Object)this);
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this);
        super.activate();
        if ("<initialize>".equals(this.getExceptionModel().getName())) {
            this.getExceptionModel().setName("");
            DirectEditRequest req = new DirectEditRequest();
            req.setType((Object)"init edit");
            this.performRequest((Request)req);
        }
    }

    @Override
    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        ((Notifier)this.getModel()).eAdapters().remove((Object)this);
        PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this);
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        this.refresh();
        this.refreshVisuals();
        this.getFigure().repaint();
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void setTarget(Notifier newTarget) {
    }
}

