/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.gef.figures.GEFLabel;
import org.jboss.tools.common.gef.figures.xpl.CustomLocator;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.XModelUtil;
import org.jboss.tools.seam.pages.xml.model.SeamPagesPreference;
import org.jboss.tools.seam.ui.pages.editor.PagesEditor;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Link;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.edit.LinkEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.edit.LinkEndpointEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.edit.PageEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesEditPart;
import org.jboss.tools.seam.ui.pages.editor.figures.ConnectionFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.FigureFactory;

public class LinkEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
EditPartListener,
XModelTreeListener {
    private static final Image icon = ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/shortcut.gif").createImage();
    private static final Font pathFont = SeamPagesPreference.getFont((String)SeamPagesPreference.LINK_PATH_FONT.getValue(), null);
    AccessibleEditPart acc;
    PagesEditor editor;
    private boolean shortcut;
    private CustomLocator shortcutLocator;
    private GEFLabel shortcutLabel;
    private CustomLocator pathLocator;
    private GEFLabel pathLabel;
    private PageEditPart pagePart = null;
    PolygonDecoration arrow;
    Adapter adapter = new AdapterImpl();

    public void setEditor(PagesEditor editor) {
        this.editor = editor;
    }

    private boolean showShortcutPath() {
        return SeamPagesPreference.SHOW_SHORTCUT_PATH.getValue().equals("yes");
    }

    private boolean showShortcutIcon() {
        return SeamPagesPreference.SHOW_SHORTCUT_ICON.getValue().equals("yes");
    }

    public void activate() {
        if (!this.isActive()) {
            ((Notifier)this.getModel()).eAdapters().add((Object)this.adapter);
        }
        super.activate();
        this.addEditPartListener(this);
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this);
        Page page = null;
        if (this.getLinkModel().getFromElement() instanceof Page) {
            page = (Page)this.getLinkModel().getFromElement();
        }
        if (page != null && this.pagePart != null) {
            this.getLinkFigure().setVisible(false);
            this.pagePart.addEditPartListener(this);
        }
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new LinkEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new LinkEditPolicy());
    }

    protected IFigure createFigure() {
        PointList list;
        if (this.getLink() == null) {
            return null;
        }
        ConnectionFigure conn = FigureFactory.createNewBendableWire(this, this.getLink());
        this.arrow = (PolygonDecoration)conn.getChildren().get(0);
        if (this.getLink().isShortcut()) {
            conn.remove((IFigure)this.arrow);
        }
        if ((list = this.getLink().getPointList()).size() > 0) {
            conn.setManual(true);
            conn.setOldPoints(list.getFirstPoint(), list.getLastPoint());
            conn.setPoints(list);
        }
        this.pathLabel = new GEFLabel(this.getLink().getName(), FigureFactory.normalColor);
        this.pathLabel.setFont(pathFont);
        this.pathLabel.setIcon(null);
        this.pathLabel.setTextAlignment(1);
        this.pathLabel.setLabelAlignment(1);
        this.pathLocator = new CustomLocator((Connection)conn, false);
        this.pathLocator.setUDistance(5);
        this.pathLocator.setVDistance(-13);
        if (!this.getLink().isShortcut()) {
            conn.add((IFigure)this.pathLabel, this.pathLocator);
        }
        String text = "";
        if (this.showShortcutPath() && this.getLink().getToElement() != null) {
            text = this.getLink().getToElement().getName();
        }
        this.shortcutLabel = new GEFLabel(text, FigureFactory.normalColor);
        if (this.showShortcutIcon()) {
            this.shortcutLabel.setIcon(icon);
        }
        this.shortcutLabel.setFont(pathFont);
        this.shortcutLabel.setTextAlignment(1);
        this.shortcutLabel.setLabelAlignment(1);
        this.shortcutLabel.setIconAlignment(1);
        this.shortcutLocator = new CustomLocator((Connection)conn, false);
        this.shortcutLocator.setUDistance(18);
        this.shortcutLocator.setVDistance(-6);
        if (this.getLink().isShortcut()) {
            conn.add((IFigure)this.shortcutLabel, this.shortcutLocator);
        }
        return conn;
    }

    public Link getLinkModel() {
        return (Link)this.getModel();
    }

    public void save() {
        PointList list = ((ConnectionFigure)this.getFigure()).getPoints();
        this.getLink().savePointList(list);
    }

    public void clear() {
        this.getLink().clearPointList();
    }

    public void deactivate() {
        if (this.pagePart != null) {
            this.pagePart.removeEditPartListener(this);
        }
        this.removeEditPartListener(this);
        PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this);
        if (this.isActive()) {
            ((Notifier)this.getModel()).eAdapters().remove((Object)this);
        }
        super.deactivate();
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path = event.getModelObject().getPath();
        if (path.equals(SeamPagesPreference.SEAM_PAGES_EDITOR_PATH)) {
            this.linkChange(this.getLink());
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        super.deactivateFigure();
    }

    public AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = "Link";
                }
            };
        }
        return this.acc;
    }

    protected Link getLink() {
        return (Link)this.getModel();
    }

    protected ConnectionFigure getLinkFigure() {
        return (ConnectionFigure)this.getFigure();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("value".equals(property)) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            if (this.getLink().isShortcut()) {
                PagesElement element = this.getLink().getToElement();
                if (element == null) {
                    return;
                }
                PagesEditPart part = (PagesEditPart)this.editor.getScrollingGraphicalViewer().getEditPartRegistry().get(element);
                if (part == null) {
                    return;
                }
                Object[] sel = new Object[]{part};
                StructuredSelection newSelection = new StructuredSelection(sel);
                this.editor.getScrollingGraphicalViewer().setSelection((ISelection)newSelection);
                PagesDiagramEditPart diagram = (PagesDiagramEditPart)this.editor.getScrollingGraphicalViewer().getRootEditPart().getChildren().get(0);
                FreeformViewport vp = diagram.getFreeformViewport();
                ((PagesEditor.ModelSelectionProvider)this.editor.getModelSelectionProvider()).scroll(vp, part.getNodeFigure());
            } else {
                XModelUtil.openProperyDialog((XModelObject)((XModelObject)this.getLink().getData()));
            }
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.shortcut = this.getLink().isShortcut();
    }

    public boolean isLinkListenerEnable() {
        return true;
    }

    public void linkChange(Link source) {
        this.pathLabel.setFont(SeamPagesPreference.getFont((String)SeamPagesPreference.LINK_PATH_FONT.getValue(), (Font)pathFont));
        this.pathLabel.setText(this.getLink().getName());
        if (this.showShortcutPath()) {
            this.shortcutLabel.setFont(SeamPagesPreference.getFont((String)SeamPagesPreference.LINK_PATH_FONT.getValue(), (Font)pathFont));
            if (this.getLink().getToElement() != null) {
                this.shortcutLabel.setText(this.getLink().getToElement().getName());
            } else {
                this.shortcutLabel.setText("");
            }
        } else {
            this.shortcutLabel.setText("");
        }
        if (this.showShortcutIcon()) {
            this.shortcutLabel.setIcon(icon);
        } else {
            this.shortcutLabel.setIcon(null);
        }
        this.getLinkFigure().refreshFont();
        if (this.shortcut != this.getLink().isShortcut()) {
            this.shortcut = this.getLink().isShortcut();
            if (this.shortcut) {
                this.getLinkFigure().add((IFigure)this.shortcutLabel, this.shortcutLocator);
                this.getLinkFigure().remove((IFigure)this.pathLabel);
                this.getLinkFigure().remove((IFigure)this.arrow);
            } else {
                this.getLinkFigure().remove((IFigure)this.shortcutLabel);
                this.getLinkFigure().add((IFigure)this.pathLabel, this.pathLocator);
                this.getLinkFigure().add((IFigure)this.arrow, new ArrowLocator((Connection)this.getLinkFigure(), 3));
            }
            this.refresh();
        }
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (editpart == this.pagePart) {
            if (this.pagePart.getSelected() == 2) {
                this.getFigure().setVisible(true);
            } else {
                this.getFigure().setVisible(false);
            }
        }
        if (editpart == this && this.getSelected() == 2) {
            ((GEFRootEditPart)this.getParent()).setToFront((AbstractConnectionEditPart)this);
        }
    }

    class AdapterImpl
    implements Adapter {
        AdapterImpl() {
        }

        public void notifyChanged(Notification notification) {
            LinkEditPart.this.linkChange(LinkEditPart.this.getLink());
            LinkEditPart.this.pathLabel.setText(LinkEditPart.this.getLinkModel().getName());
            if (LinkEditPart.this.getLinkFigure().isManual() && LinkEditPart.this.getLink().getPathFromModel().equals("")) {
                LinkEditPart.this.getLinkFigure().setManual(false);
                LinkEditPart.this.clear();
            } else if (!LinkEditPart.this.getLinkFigure().isManual() && !LinkEditPart.this.getLink().getPathFromModel().equals("")) {
                LinkEditPart.this.getLinkFigure().setManual(true);
            }
            PointList list = LinkEditPart.this.getLink().getPointList();
            if (list.size() == 0) {
                ((ConnectionFigure)LinkEditPart.this.figure).setManual(false);
            }
            LinkEditPart.this.refresh();
            LinkEditPart.this.refreshVisuals();
            ((ConnectionFigure)LinkEditPart.this.figure).layout();
        }

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void setTarget(Notifier newTarget) {
        }
    }
}

