/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ReconnectRequest;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.seam.ui.pages.editor.commands.ReconnectSourceLinkCommand;
import org.jboss.tools.seam.ui.pages.editor.commands.ReconnectSourceLinkCommand2;
import org.jboss.tools.seam.ui.pages.editor.commands.ReconnectTargetLinkCommand;
import org.jboss.tools.seam.ui.pages.editor.dnd.DndHelper;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.edit.LinkEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PageEditPart;

public class PageEditPolicy
extends ComponentEditPolicy {
    private PageEditPart getPageEditPart() {
        return (PageEditPart)this.getHost();
    }

    public Command getCommand(Request request) {
        if ("connection end".equals(request.getType())) {
            return this.getConnectionEndCommand();
        }
        if ("Reconnection source".equals(request.getType())) {
            return this.getReconnectionSourceCommand((ReconnectRequest)request);
        }
        if ("Reconnection target".equals(request.getType())) {
            return this.getReconnectionTargetCommand((ReconnectRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getConnectionEndCommand() {
        Page p = (Page)this.getPageEditPart().getModel();
        if (!DndHelper.isDropEnabled((XModelObject)p.getData())) {
            return null;
        }
        ConnectionEndCommand command = new ConnectionEndCommand();
        command.setChild(p);
        return command;
    }

    protected Command getReconnectionSourceCommand(ReconnectRequest request) {
        ReconnectSourceLinkCommand command = new ReconnectSourceLinkCommand();
        ConnectionAnchor ctor = this.getPageEditPart().getSourceConnectionAnchor((Request)request);
        List list = this.getPageEditPart().getSourceConnections();
        int i = 0;
        while (i < list.size()) {
            LinkEditPart part = (LinkEditPart)list.get(i);
            if (!part.equals(request.getConnectionEditPart()) && part != null && part.getConnectionFigure().getSourceAnchor().equals(ctor)) {
                command.setLink(part.getLink());
                return command;
            }
            ++i;
        }
        ReconnectSourceLinkCommand2 command2 = new ReconnectSourceLinkCommand2();
        command2.setPage(this.getPageEditPart().getPageModel());
        return command2;
    }

    protected Command getReconnectionTargetCommand(ReconnectRequest request) {
        Page p = (Page)this.getPageEditPart().getModel();
        ReconnectTargetLinkCommand command = new ReconnectTargetLinkCommand();
        command.setChild(p);
        return command;
    }

    static class ConnectionEndCommand
    extends Command {
        Page child = null;

        public ConnectionEndCommand() {
            super("ConnectionEndCommand");
        }

        public void setChild(Page child) {
            this.child = child;
        }

        public void execute() {
        }

        public boolean canUndo() {
            return false;
        }
    }
}

