/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.SquareHandle;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesConnectionDragTracker;

public class PagesConnectionHandle
extends SquareHandle
implements PropertyChangeListener {
    private boolean vertical = false;
    private int index;

    public PagesConnectionHandle(ConnectionEditPart owner, boolean vertical, int index) {
        this.vertical = vertical;
        this.index = index;
        if (vertical) {
            this.setCursor(Cursors.SIZEN);
        } else {
            this.setCursor(Cursors.SIZEW);
        }
        this.setOwner((GraphicalEditPart)owner);
        this.setLocator((Locator)new JSFMidpointLocator(this.getConnection(), index));
    }

    protected DragTracker createDragTracker() {
        PagesConnectionDragTracker tracker = new PagesConnectionDragTracker((ConnectionEditPart)this.getOwner(), this.vertical, this.index);
        return tracker;
    }

    public void addNotify() {
        super.addNotify();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    public Connection getConnection() {
        return (Connection)this.getOwnerFigure();
    }

    protected boolean isVertical() {
        return this.vertical;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("points")) {
            this.revalidate();
        }
    }

    public void removeNotify() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.removeNotify();
    }

    class JSFMidpointLocator
    extends ConnectionLocator {
        private int index;

        public JSFMidpointLocator(Connection c, int i) {
            super(c);
            this.index = i;
        }

        protected int getIndex() {
            return this.index;
        }

        protected Point getReferencePoint() {
            Connection conn = super.getConnection();
            if (this.getIndex() + 1 > conn.getPoints().size() - 2) {
                PagesConnectionHandle.this.setVisible(false);
                return new Point(0, 0);
            }
            Point p = Point.SINGLETON;
            Point p1 = conn.getPoints().getPoint(this.getIndex());
            Point p2 = conn.getPoints().getPoint(this.getIndex() + 1);
            conn.translateToAbsolute((Translatable)p1);
            conn.translateToAbsolute((Translatable)p2);
            p.x = (p2.x - p1.x) / 2 + p1.x;
            p.y = (p2.y - p1.y) / 2 + p1.y;
            return p;
        }
    }
}

