/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.util.Properties;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.seam.pages.xml.model.SeamPagesXModelUtil;
import org.jboss.tools.seam.ui.pages.editor.ExceptionTemplate;
import org.jboss.tools.seam.ui.pages.editor.PageTemplate;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModel;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;

public class PagesDiagramEditPolicy
extends RootComponentEditPolicy {
    public PagesDiagramEditPart getDiagramEditPart() {
        return (PagesDiagramEditPart)this.getHost();
    }

    public Command getCommand(Request request) {
        if ("create child".equals(request.getType())) {
            CreateRequest req = (CreateRequest)request;
            if (req.getNewObjectType().equals(ExceptionTemplate.class)) {
                return this.getCreateExceptionCommand((CreateRequest)request);
            }
            if (req.getNewObjectType().equals(PageTemplate.class)) {
                return this.getCreatePageCommand((CreateRequest)request);
            }
        }
        return super.getCommand(request);
    }

    public Command getCreateExceptionCommand(CreateRequest request) {
        CreateExceptionCommand comm = new CreateExceptionCommand();
        comm.setLocation(request.getLocation());
        return comm;
    }

    public Command getCreatePageCommand(CreateRequest request) {
        CreatePageCommand comm = new CreatePageCommand();
        comm.setLocation(request.getLocation());
        return comm;
    }

    class CreateExceptionCommand
    extends Command {
        Point location;

        public void setLocation(Point point) {
            PagesDiagramEditPolicy.this.getDiagramEditPart().getFigure().translateToRelative((Translatable)point);
            this.location = point;
        }

        public CreateExceptionCommand() {
            super("CreateExceptionCommand");
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            Properties properties = new Properties();
            if (this.location != null) {
                properties.put("mouse.x", "" + this.location.x);
                properties.put("mouse.y", "" + this.location.y);
            }
            properties.put("diagramEditPart", PagesDiagramEditPolicy.this.getDiagramEditPart());
            SeamPagesXModelUtil.addException((XModelObject)((XModelObject)((PagesModel)PagesDiagramEditPolicy.this.getDiagramEditPart().getModel()).getData()), (Properties)properties);
        }

        public boolean canUndo() {
            return false;
        }
    }

    class CreatePageCommand
    extends Command {
        Point location;

        public void setLocation(Point point) {
            PagesDiagramEditPolicy.this.getDiagramEditPart().getFigure().translateToRelative((Translatable)point);
            this.location = point;
        }

        public CreatePageCommand() {
            super("CreatePageCommand");
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            Properties properties = new Properties();
            if (this.location != null) {
                properties.put("mouse.x", "" + this.location.x);
                properties.put("mouse.y", "" + this.location.y);
            }
            properties.put("diagramEditPart", PagesDiagramEditPolicy.this.getDiagramEditPart());
            SeamPagesXModelUtil.addPage((XModelObject)((XModelObject)((PagesModel)PagesDiagramEditPolicy.this.getDiagramEditPart().getModel()).getData()), (Properties)properties);
        }

        public boolean canUndo() {
            return false;
        }
    }
}

