/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesNodeEditPolicy;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;

public abstract class PagesEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
PropertyChangeListener {
    private AccessibleEditPart acc;

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
    }

    public PagesElement getElementModel() {
        return (PagesElement)this.getModel();
    }

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new PagesNodeEditPolicy());
    }

    protected abstract AccessibleEditPart createAccessible();

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return this.getNodeFigure().getConnectionAnchorName(c);
    }

    protected void refreshVisuals() {
        Point loc = new Point(100, 100);
        Dimension size = new Dimension(56, 100);
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    protected void refreshSourceConnections() {
        ConnectionEditPart connectEditPart;
        HashMap<Object, ConnectionEditPart> mapModelToPart = new HashMap<Object, ConnectionEditPart>();
        List parts = this.getSourceConnections();
        int i = 0;
        while (i < parts.size()) {
            connectEditPart = (ConnectionEditPart)parts.get(i);
            mapModelToPart.put(connectEditPart.getModel(), connectEditPart);
            ++i;
        }
        ArrayList modelEntries = this.getModelSourceConnections();
        if (modelEntries == null) {
            modelEntries = new ArrayList();
        }
        i = 0;
        while (i < modelEntries.size()) {
            Object modelEntry = modelEntries.get(i);
            if (i < parts.size() && (connectEditPart = (ConnectionEditPart)parts.get(i)).getModel() == modelEntry) {
                if (connectEditPart.getSource() != this) {
                    connectEditPart.setSource((EditPart)this);
                }
            } else {
                connectEditPart = (ConnectionEditPart)mapModelToPart.get(modelEntry);
                if (connectEditPart != null) {
                    this.reorderSourceConnection(connectEditPart, i);
                } else {
                    connectEditPart = this.createOrFindConnection(modelEntry);
                    this.addSourceConnection(connectEditPart, i);
                }
            }
            ++i;
        }
        ArrayList trash = new ArrayList();
        while (i < parts.size()) {
            trash.add(parts.get(i));
            ++i;
        }
        i = 0;
        while (i < trash.size()) {
            this.removeSourceConnection((ConnectionEditPart)trash.get(i));
            ++i;
        }
    }

    protected void refreshTargetConnections() {
        ConnectionEditPart connectEditPart;
        HashMap<Object, ConnectionEditPart> mapModelToEditPart = new HashMap<Object, ConnectionEditPart>();
        List connections = this.getTargetConnections();
        int i = 0;
        while (i < connections.size()) {
            connectEditPart = (ConnectionEditPart)connections.get(i);
            mapModelToEditPart.put(connectEditPart.getModel(), connectEditPart);
            ++i;
        }
        ArrayList modelEntries = this.getModelTargetConnections();
        if (modelEntries == null) {
            modelEntries = new ArrayList();
        }
        i = 0;
        while (i < modelEntries.size()) {
            Object modelEntry = modelEntries.get(i);
            if (i < connections.size() && (connectEditPart = (ConnectionEditPart)connections.get(i)).getModel() == modelEntry) {
                if (connectEditPart.getTarget() != this) {
                    connectEditPart.setTarget((EditPart)this);
                }
            } else {
                connectEditPart = (ConnectionEditPart)mapModelToEditPart.get(modelEntry);
                if (connectEditPart != null) {
                    this.reorderTargetConnection(connectEditPart, i);
                } else {
                    connectEditPart = this.createOrFindConnection(modelEntry);
                    this.addTargetConnection(connectEditPart, i);
                }
            }
            ++i;
        }
        ArrayList removed = new ArrayList();
        while (i < connections.size()) {
            removed.add(connections.get(i));
            ++i;
        }
        i = 0;
        while (i < removed.size()) {
            this.removeTargetConnection((ConnectionEditPart)removed.get(i));
            ++i;
        }
    }

    protected void removeSourceConnection(ConnectionEditPart connection) {
        if (connection.getSource() != this) {
            return;
        }
        this.fireRemovingSourceConnection(connection, this.getSourceConnections().indexOf(connection));
        connection.deactivate();
        connection.setSource(null);
        this.primRemoveSourceConnection(connection);
    }

    protected void removeTargetConnection(ConnectionEditPart connection) {
        if (connection.getTarget() != this) {
            return;
        }
        this.fireRemovingTargetConnection(connection, this.getTargetConnections().indexOf(connection));
        connection.setTarget(null);
        this.primRemoveTargetConnection(connection);
    }

    protected void adjustForGrid(Point loc) {
        loc.x -= loc.x % 8;
        loc.y -= loc.y % 8;
    }

    public void doMouseDown(Point point) {
    }
}

