/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.util.Properties;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.pages.xml.model.handlers.RenameViewSupport;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;
import org.jboss.tools.seam.ui.pages.SeamUiPagesPlugin;
import org.jboss.tools.seam.ui.pages.editor.commands.AddExceptionOnDiagramHandler;
import org.jboss.tools.seam.ui.pages.editor.commands.AddPageOnDiagramHandler;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PageException;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDValidator;

public class ViewIDDirectEditPolicy
extends DirectEditPolicy {
    protected Command getDirectEditCommand(DirectEditRequest request) {
        String labelText = (String)request.getCellEditor().getValue();
        PagesEditPart node = (PagesEditPart)this.getHost();
        PagesElement element = node.getElementModel();
        if (element != null) {
            Object rename = request.getExtendedData().get("rename");
            if (rename != null && rename instanceof Boolean && ((Boolean)rename).booleanValue()) {
                return new RenameViewCommand(element, labelText);
            }
            return new InitViewCommand(element, labelText);
        }
        return null;
    }

    protected void showCurrentEditValue(DirectEditRequest request) {
    }

    public class InitViewCommand
    extends Command {
        PagesElement node;
        String value;
        XModelObject object;

        public InitViewCommand(PagesElement node, String value) {
            this.node = node;
            this.value = value;
            this.object = (XModelObject)node.getPagesModel().getData();
        }

        public boolean canExecute() {
            ViewIDValidator val = new ViewIDValidator(this.object);
            String message = val.isValid(this.value);
            return message == null || "".equals(message);
        }

        public boolean canUndo() {
            return false;
        }

        public void execute() {
            Properties props = new Properties();
            props.setProperty("mouse.x", "" + this.node.getLocation().x);
            props.setProperty("mouse.y", "" + this.node.getLocation().y);
            if (this.node instanceof Page) {
                AddPageOnDiagramHandler.createPage(this.object, this.value, props);
            } else if (this.node instanceof PageException) {
                AddExceptionOnDiagramHandler.createException(this.object, this.value, props);
            }
        }
    }

    public class RenameViewCommand
    extends Command {
        PagesElement node;
        String value;
        XModelObject object;
        String oldValue;

        public RenameViewCommand(PagesElement node, String value) {
            this.node = node;
            this.value = value;
            this.object = (XModelObject)node.getData();
            this.oldValue = this.object.getAttributeValue("path");
        }

        public boolean canExecute() {
            ViewIDValidator val = new ViewIDValidator(this.object);
            String message = val.isValid(this.value);
            return message == null || "".equals(message);
        }

        public boolean canUndo() {
            return false;
        }

        public void execute() {
            if (this.node instanceof Page && this.object instanceof ReferenceObject) {
                SeamPagesDiagramHelper h = SeamPagesDiagramHelper.getHelper((XModelObject)SeamPagesDiagramStructureHelper.instance.getDiagram(this.object));
                h.addUpdateLock((Object)this);
                try {
                    try {
                        RenameViewSupport.replace((ReferenceObject)((ReferenceObject)this.object), (String)this.oldValue, (String)this.value);
                    }
                    catch (XModelException ex) {
                        SeamUiPagesPlugin.log(ex);
                        h.removeUpdateLock((Object)this);
                        h.updateDiagram();
                    }
                }
                finally {
                    h.removeUpdateLock((Object)this);
                    h.updateDiagram();
                }
            }
        }
    }
}

