/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.seam.ui.pages.editor.edit.PageWrapper;
import org.jboss.tools.seam.ui.pages.editor.edit.ParamListEditPart;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.ParamListLayout;

public class ParamListFigure
extends NodeFigure
implements HandleBounds {
    private static final Dimension SIZE = new Dimension(56, 100);
    private static final Color darkGrayColor = new Color(null, 179, 179, 179);
    public PageWrapper paramList;
    ParamListEditPart editPart;
    int width;
    int height;
    private int nameWidth = 0;

    public void setEditPart(ParamListEditPart part) {
        this.editPart = part;
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public ParamListFigure(PageWrapper paramList) {
        this.paramList = paramList;
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new ParamListLayout());
        this.setBorder((Border)new GroupBorder(ColorConstants.black));
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        g.setBackgroundColor(lightGrayColor);
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        g.fillRectangle(1, 1, r.width - 2, r.height - 2);
    }

    public void setNameWidth(int nameWidth) {
        this.nameWidth = nameWidth;
    }

    public int getNameWidth() {
        return this.nameWidth;
    }

    class GroupBorder
    extends LineBorder {
        public GroupBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = GroupBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            graphics.setForegroundColor(darkGrayColor);
            graphics.drawLine(1, 0, width - 1, 0);
            graphics.drawLine(0, 1, 0, height - 1);
            graphics.drawLine(1, height, width - 1, height);
            graphics.drawLine(width, 1, width, height - 1);
        }
    }
}

