/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.figures.xpl;

public class CompressNameUtil {
    private static String fgNamePattern = "";
    private static String fgNamePrefix;
    private static String fgNamePostfix;
    private static int fgNameChars;
    private static int fgNameLength;

    static {
        fgNameLength = -1;
    }

    public static String getCompressedName(String className) {
        StringBuffer result = new StringBuffer();
        CompressNameUtil.refreshPackageNamePattern();
        if (fgNameLength == 0) {
            result.append(className);
            return result.toString();
        }
        String name = className;
        int start = 0;
        int dot = name.indexOf(46, start);
        while (dot > 0) {
            if (dot - start > fgNameLength - 1) {
                result.append(fgNamePrefix);
                if (fgNameChars > 0) {
                    result.append(name.substring(start, Math.min(start + fgNameChars, dot)));
                }
                result.append(fgNamePostfix);
            } else {
                result.append(name.substring(start, dot + 1));
            }
            start = dot + 1;
            dot = name.indexOf(46, start);
        }
        result.append(name.substring(start));
        return result.toString();
    }

    private static void refreshPackageNamePattern() {
        String pattern = "1.";
        if (pattern.equals(fgNamePattern)) {
            return;
        }
        if (pattern.length() == 0) {
            fgNamePattern = "";
            fgNameLength = -1;
            return;
        }
        fgNamePattern = pattern;
        int i = 0;
        fgNameChars = 0;
        fgNamePrefix = "";
        fgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgNameChars = ch - 48;
                if (i > 0) {
                    fgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgNamePostfix = pattern.substring(i + 1);
                }
                fgNameLength = fgNamePrefix.length() + fgNameChars + fgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgNamePrefix = pattern;
        fgNameLength = pattern.length();
    }
}

