/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.marker;

import java.text.MessageFormat;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.java.generation.JavaPropertyGenerator;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.ui.SeamGuiPlugin;

public class AddSetterMarkerResolution
implements IMarkerResolution2 {
    private ISeamProperty property;
    private ISeamJavaComponentDeclaration javaDeclaration;
    private String label;

    public AddSetterMarkerResolution(ISeamProperty property, ISeamJavaComponentDeclaration javaDeclaration) {
        this.property = property;
        this.javaDeclaration = javaDeclaration;
        this.label = MessageFormat.format(SeamCoreMessages.ADD_SETTER_MARKER_RESOLUTION_TITLE, property.getName(), javaDeclaration.getClassName());
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IMarker marker) {
        IFile file = (IFile)this.javaDeclaration.getResource();
        try {
            String setterName;
            String stub;
            IMethod newMethod;
            ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)file);
            if (original == null) {
                return;
            }
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            String lineDelim = JavaPropertyGenerator.getLineDelimiterUsed((ICompilationUnit)compilationUnit);
            Hashtable options = JavaCore.getOptions();
            int tabSize = new Integer((String)options.get("org.eclipse.jdt.core.formatter.tabulation.size"));
            StringBuffer tabBuf = new StringBuffer();
            int i = 0;
            while (i < tabSize) {
                tabBuf.append(" ");
                ++i;
            }
            String tab = tabBuf.toString();
            IType type = compilationUnit.findPrimaryType();
            IField field = type.getField(this.property.getName());
            String propertyType = "";
            if (field != null && field.exists()) {
                propertyType = field.getTypeSignature();
            } else {
                propertyType = "String";
                StringBuffer buf = new StringBuffer();
                buf.append(String.valueOf(tab) + "private " + propertyType + " " + this.property.getName() + ";");
                buf.append(lineDelim);
                field = type.createField(buf.toString(), null, false, (IProgressMonitor)new NullProgressMonitor());
                if (field != null) {
                    IBuffer buffer = compilationUnit.getBuffer();
                    buffer.replace(field.getSourceRange().getOffset(), field.getSourceRange().getLength(), buf.toString());
                    ICompilationUnit iCompilationUnit = compilationUnit;
                    synchronized (iCompilationUnit) {
                        compilationUnit.reconcile(0, true, null, null);
                    }
                }
            }
            IMethod oldMethod = GetterSetterUtil.getSetter((IField)field);
            if (!(oldMethod != null && oldMethod.exists() || (newMethod = type.createMethod(stub = GetterSetterUtil.getSetterStub((IField)field, (String)(setterName = GetterSetterUtil.getSetterName((IField)field, null)), (boolean)true, (int)1), null, false, (IProgressMonitor)new NullProgressMonitor())) == null)) {
                IBuffer buffer = compilationUnit.getBuffer();
                StringBuffer buf = new StringBuffer();
                buf.append(lineDelim);
                buf.append(String.valueOf(tab) + "public void " + setterName + "(" + propertyType + " " + this.property.getName() + "){");
                buf.append(lineDelim);
                buf.append(String.valueOf(tab) + tab + "this." + this.property.getName() + " = " + this.property.getName() + ";");
                buf.append(lineDelim);
                buf.append(String.valueOf(tab) + "}");
                buf.append(lineDelim);
                buffer.replace(newMethod.getSourceRange().getOffset(), newMethod.getSourceRange().getLength(), buf.toString());
            }
            compilationUnit.commitWorkingCopy(false, (IProgressMonitor)new NullProgressMonitor());
            compilationUnit.discardWorkingCopy();
        }
        catch (CoreException ex) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return null;
    }
}

