/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.ui.preferences.SeamPreferencesMessages;
import org.jboss.tools.seam.ui.widget.editor.SeamRuntimeListFieldEditor;

public class SeamPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String SEAM_PREFERENCES_ID = "org.jboss.tools.common.model.ui.seam";
    private static final int COLUMNS = 3;
    SeamRuntimeListFieldEditor seamRuntimes = new SeamRuntimeListFieldEditor("rtlist", SeamPreferencesMessages.SEAM_PREFERENCE_PAGE_SEAM_RUNTIMES, new ArrayList<SeamRuntime>(Arrays.asList(SeamRuntimeManager.getInstance().getRuntimes())));

    public SeamPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData layoutData = new GridData(4, 4, true, true);
        root.setLayoutData((Object)layoutData);
        root.setLayout((Layout)layout);
        Group seamRuntimeGroup = this.createGroup(root, 1);
        GridLayout gl = new GridLayout();
        seamRuntimeGroup.setLayout((Layout)gl);
        seamRuntimeGroup.setLayoutData((Object)new GridData(768));
        seamRuntimeGroup.setText(SeamPreferencesMessages.SEAM_PREFERENCE_PAGE_SEAM_RUNTIMES);
        Label seamRuntimeDescription = new Label((Composite)seamRuntimeGroup, 64);
        seamRuntimeDescription.setText(SeamPreferencesMessages.SEAM_PREFERENCE_PAGE_DESCRIPTION);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 200;
        seamRuntimeDescription.setLayoutData((Object)gridData);
        Composite container = new Composite((Composite)seamRuntimeGroup, 0);
        gl = new GridLayout(3, false);
        container.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        this.seamRuntimes.doFillIntoGrid(container);
        this.seamRuntimes.setPreferencePage(this);
        return root;
    }

    private Group createGroup(Composite composite, int column) {
        Group group = new Group(composite, 0);
        GridData gd = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(column, false);
        group.setLayout((Layout)layout);
        return group;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        List<SeamRuntime> defaultRuntimes = this.seamRuntimes.getDefaultSeamRuntimes();
        SeamRuntime[] seamRuntimeArray = SeamRuntimeManager.getInstance().getRuntimes();
        int n = seamRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime seamRuntime = seamRuntimeArray[n2];
            seamRuntime.setDefault(false);
            ++n2;
        }
        for (SeamRuntime seamRuntime : defaultRuntimes) {
            seamRuntime.setDefault(true);
        }
        this.seamRuntimes.getDefaultSeamRuntimes().clear();
        SeamRuntimeManager.getInstance().save();
    }

    protected void performDefaults() {
        this.setValid(true);
        this.setMessage(null);
        this.performApply();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void dispose() {
        this.seamRuntimes.dispose();
        super.dispose();
    }
}

