/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.seam.core.ISeamDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.ui.SeamGuiPlugin;

public class SeamElementMatch
extends Match {
    private long fCreationTimeStamp;

    public SeamElementMatch(ISeamElement element) {
        super((Object)element, 0, 0);
        this.fCreationTimeStamp = element.getResource().getModificationStamp();
    }

    public SeamElementMatch(IJavaSourceReference element) {
        super((Object)element, 0, 0);
        if (element != null && element.getSourceMember() != null && element.getSourceMember().getResource() != null) {
            this.fCreationTimeStamp = element.getSourceMember().getResource().getModificationStamp();
        } else {
            try {
                this.fCreationTimeStamp = element != null && element.getSourceMember().getUnderlyingResource() != null ? element.getSourceMember().getUnderlyingResource().getModificationStamp() : 0L;
            }
            catch (JavaModelException e) {
                this.fCreationTimeStamp = 0L;
                SeamGuiPlugin.getDefault().logError(e);
            }
        }
    }

    public SeamElementMatch(ISeamDeclaration element) {
        super((Object)element, 0, 0);
        this.fCreationTimeStamp = element.getResource().getModificationStamp();
    }

    public SeamElementMatch(IFile element, int offset, int length) {
        super((Object)element, offset, length);
        this.fCreationTimeStamp = element.getModificationStamp();
    }

    public IFile getFile() {
        if (this.getElement() instanceof IJavaSourceReference) {
            return (IFile)((IJavaSourceReference)this.getElement()).getSourceMember().getResource();
        }
        if (this.getElement() instanceof ISeamDeclaration) {
            return (IFile)((ISeamDeclaration)this.getElement()).getResource();
        }
        if (this.getElement() instanceof IFile) {
            return (IFile)this.getElement();
        }
        return (IFile)((ISeamElement)this.getElement()).getResource();
    }

    public long getCreationTimeStamp() {
        return this.fCreationTimeStamp;
    }
}

