/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.seam.core.ISeamDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.ui.search.SeamElementMatch;
import org.jboss.tools.seam.ui.search.SeamSearchEngine;
import org.jboss.tools.seam.ui.search.SeamSearchRequestor;
import org.jboss.tools.seam.ui.search.SeamSearchResult;
import org.jboss.tools.seam.ui.search.SeamSearchScope;

public class SeamSearchQuery
implements ISearchQuery {
    private ELInvocationExpression fTokens;
    private IJavaElement[] fJavaElements;
    private final SeamSearchScope fScope;
    private SeamSearchResult fResult;
    private IFile fSourceFile;
    private ISearchRequestor fParentRequestor;

    public SeamSearchQuery(ELInvocationExpression tokens, IFile sourceFile, SeamSearchScope scope) {
        this.fTokens = tokens;
        this.fJavaElements = null;
        this.fSourceFile = sourceFile;
        this.fScope = scope;
    }

    public SeamSearchQuery(IJavaElement[] javaElements, IFile sourceFile, SeamSearchScope scope) {
        this.fTokens = null;
        this.fJavaElements = javaElements;
        this.fSourceFile = sourceFile;
        this.fScope = scope;
    }

    public void setParentRequestor(ISearchRequestor requestor) {
        this.fParentRequestor = requestor;
    }

    public ISearchRequestor getParentRequestor() {
        return this.fParentRequestor;
    }

    public SeamSearchScope getSearchScope() {
        return this.fScope;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        if (this.fJavaElements != null) {
            return this.queryByJavaElements(textResult, monitor);
        }
        if (this.fTokens != null) {
            return this.queryByTokens(textResult, monitor);
        }
        return Status.OK_STATUS;
    }

    private IStatus queryByTokens(AbstractTextSearchResult textResult, IProgressMonitor monitor) {
        IProject project = this.fSourceFile == null ? null : this.fSourceFile.getProject();
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        if (seamProject == null) {
            return Status.OK_STATUS;
        }
        new SeamELCompletionEngine();
        SeamSearchResultCollector collector = new SeamSearchResultCollector(textResult, this.getParentRequestor());
        return SeamSearchEngine.getInstance().search(this.fScope, (SeamSearchRequestor)collector, this.fSourceFile, this.fTokens, monitor);
    }

    private IStatus queryByJavaElements(AbstractTextSearchResult textResult, IProgressMonitor monitor) {
        IProject project = this.fSourceFile == null ? null : this.fSourceFile.getProject();
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        if (seamProject == null) {
            return Status.OK_STATUS;
        }
        new SeamELCompletionEngine();
        SeamSearchResultCollector collector = new SeamSearchResultCollector(textResult, this.getParentRequestor());
        return SeamSearchEngine.getInstance().search(this.fScope, (SeamSearchRequestor)collector, this.fSourceFile, this.fJavaElements, monitor);
    }

    private boolean isScopeAllFileTypes() {
        String[] fileNamePatterns = this.fScope.getFileNamePatterns();
        if (fileNamePatterns == null) {
            return true;
        }
        int i = 0;
        while (i < fileNamePatterns.length) {
            if ("*".equals(fileNamePatterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getLabel() {
        Object[] args = new Object[]{this.fScope.getLimitToDescription()};
        return Messages.format((String)SeamCoreMessages.SeamSearchQuery_label, (Object[])args);
    }

    public String getSearchString() {
        String searchString = "";
        if (this.fJavaElements != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fJavaElements.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.fJavaElements[i]);
                ++i;
            }
            searchString = buf.toString();
        } else if (this.fTokens != null) {
            searchString = this.fTokens.getText();
        }
        return searchString;
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (searchString.length() > 0) {
            if (SeamSearchEngine.isSearchForDeclarations(this.fScope.getLimitTo())) {
                if (nMatches == 1) {
                    Object[] args = new Object[]{searchString, this.fScope.getDescription(), this.fScope.getLimitToDescription()};
                    return Messages.format((String)SeamCoreMessages.SeamSearchQuery_singularPatternWithLimitTo, (Object[])args);
                }
                Object[] args = new Object[]{searchString, new Integer(nMatches), this.fScope.getDescription(), this.fScope.getLimitToDescription()};
                return Messages.format((String)SeamCoreMessages.SeamSearchQuery_pluralPatternWithLimitTo, (Object[])args);
            }
            if (SeamSearchEngine.isSearchForReferences(this.fScope.getLimitTo()) && this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    Object[] args = new Object[]{searchString, this.fScope.getDescription(), this.fScope.getLimitToDescription()};
                    return Messages.format((String)SeamCoreMessages.SeamSearchQuery_singularLabel, (Object[])args);
                }
                Object[] args = new Object[]{searchString, new Integer(nMatches), this.fScope.getDescription(), this.fScope.getLimitToDescription()};
                return Messages.format((String)SeamCoreMessages.SeamSearchQuery_pluralPattern, (Object[])args);
            }
        }
        return "";
    }

    public static Pattern getSearchPattern(String variableName) {
        return PatternConstructor.createPattern((String)variableName, (boolean)true, (boolean)false);
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new SeamSearchResult(this);
            new SearchResultUpdater((AbstractTextSearchResult)this.fResult);
        }
        return this.fResult;
    }

    public static final class SeamSearchResultCollector
    extends SeamSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private ArrayList<Match> fCachedMatches;
        private final ISearchRequestor fParentRequestor;

        public SeamSearchResultCollector(AbstractTextSearchResult result, ISearchRequestor parentRequestor) {
            this.fResult = result;
            this.fParentRequestor = parentRequestor;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            this.flushMatches();
            return true;
        }

        public boolean reportBinaryFile(IFile file) {
            return false;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            int matchOffset = matchRequestor.getMatchOffset();
            LineElement lineElement = this.getLineElement(matchOffset, matchRequestor);
            if (lineElement != null) {
                this.fCachedMatches.add((Match)new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength(), lineElement));
            }
            return true;
        }

        private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor) {
            int lineNumber = 1;
            int lineStart = 0;
            if (!this.fCachedMatches.isEmpty()) {
                FileMatch last = (FileMatch)this.fCachedMatches.get(this.fCachedMatches.size() - 1);
                LineElement lineElement = last.getLineElement();
                if (lineElement.contains(offset)) {
                    return lineElement;
                }
                lineStart = lineElement.getOffset() + lineElement.getLength();
                lineNumber = lineElement.getLine() + 1;
            }
            if (offset < lineStart) {
                return null;
            }
            int i = lineStart;
            int contentLength = matchRequestor.getFileContentLength();
            while (i < contentLength) {
                char ch;
                if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
                if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                    ++i;
                }
                if (offset < i) {
                    String lineContent = SeamSearchResultCollector.getContents(matchRequestor, lineStart, i);
                    return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
                }
                ++lineNumber;
                lineStart = i;
            }
            if (offset < i) {
                String lineContent = SeamSearchResultCollector.getContents(matchRequestor, lineStart, i);
                return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
            }
            return null;
        }

        private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
            StringBuffer buf = new StringBuffer();
            int i = start;
            while (i < end) {
                char ch = matchRequestor.getFileContentChar(i);
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    buf.append(' ');
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            return buf.toString();
        }

        @Override
        public boolean acceptSeamDeclarationSourceReferenceMatch(IJavaSourceReference element) throws CoreException {
            this.fCachedMatches.add(new SeamElementMatch(element));
            return true;
        }

        @Override
        public boolean acceptSeamDeclarationMatch(ISeamDeclaration element) throws CoreException {
            this.fCachedMatches.add(new SeamElementMatch(element));
            return true;
        }

        public void beginReporting() {
            this.fCachedMatches = new ArrayList();
        }

        public void endReporting() {
            this.flushMatches();
            this.fCachedMatches = null;
        }

        private void flushMatches() {
            if (!this.fCachedMatches.isEmpty()) {
                if (this.fResult != null) {
                    this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
                }
                if (this.fParentRequestor != null) {
                    for (Match match : this.fCachedMatches) {
                        this.fParentRequestor.reportMatch(match);
                    }
                }
                this.fCachedMatches.clear();
            }
        }

        @Override
        public void reportMatch(Match match) {
            this.fCachedMatches.add(match);
        }
    }
}

