/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.search.SeamSearchEngine;

public class SeamSearchScope
extends TextSearchScope
implements IJavaSearchScope {
    public static final int SEARCH_FOR_DECLARATIONS = 0;
    public static final int SEARCH_FOR_REFERENCES = 2;
    private static final String[] FILE_NAMES = new String[]{"*"};
    int fLimitTo;
    String fDescription;
    FileTextSearchScope fFileTextSearchScope;
    IJavaSearchScope fJavaSearchScope;

    public SeamSearchScope(IJavaSearchScope javaScope, int limitTo) {
        this.fJavaSearchScope = javaScope;
        ProjectVisitor projectVisitor = new ProjectVisitor(this.fJavaSearchScope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)projectVisitor, 0);
        }
        catch (CoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
        IProject[] projects = projectVisitor.getProjects();
        this.fFileTextSearchScope = FileTextSearchScope.newSearchScope((IResource[])projects, (String[])FILE_NAMES, (boolean)true);
        this.fDescription = this.getScopeDescription((IResource[])projects);
        this.fLimitTo = limitTo;
    }

    public SeamSearchScope(IResource[] resources, int limitTo) {
        this.fFileTextSearchScope = FileTextSearchScope.newSearchScope((IResource[])resources, (String[])FILE_NAMES, (boolean)true);
        this.fDescription = this.getScopeDescription(resources);
        this.fLimitTo = limitTo;
    }

    private String getScopeDescription(IResource[] resources) {
        String description;
        if (resources.length == 0) {
            description = SeamCoreMessages.SeamSearchScope_scope_empty;
        } else if (resources.length == 1) {
            String label = SeamCoreMessages.SeamSearchScope_scope_single;
            description = Messages.format((String)label, (Object)resources[0].getName());
        } else if (resources.length == 2) {
            String label = SeamCoreMessages.SeamSearchScope_scope_double;
            description = Messages.format((String)label, (Object[])new String[]{resources[0].getName(), resources[1].getName()});
        } else {
            String label = SeamCoreMessages.SeamSearchScope_scope_multiple;
            description = Messages.format((String)label, (Object[])new String[]{resources[0].getName(), resources[1].getName()});
        }
        return description;
    }

    public int getLimitTo() {
        return this.fLimitTo;
    }

    public boolean contains(IResourceProxy proxy) {
        return this.fFileTextSearchScope.contains(proxy);
    }

    public String[] getFileNamePatterns() {
        return this.fFileTextSearchScope.getFileNamePatterns();
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getLimitToDescription() {
        return SeamSearchEngine.isSearchForDeclarations(this.getLimitTo()) ? SeamCoreMessages.SeamSearchScope_scope_LimitToDeclarations : SeamCoreMessages.SeamSearchScope_scope_LimitToReferences;
    }

    public String getFilterDescription() {
        return this.fFileTextSearchScope.getFilterDescription();
    }

    public IResource[] getRoots() {
        return this.fFileTextSearchScope.getRoots();
    }

    public ISeamProject[] evaluateSeamProjectsInScope(MultiStatus status) {
        IFile[] files = this.evaluateFilesInScope(status);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        ArrayList<ISeamProject> seamProjects = new ArrayList<ISeamProject>();
        int i = 0;
        while (files != null && i < files.length) {
            ISeamProject seamProject;
            IProject project;
            IProject iProject = project = files[i] == null ? null : files[i].getProject();
            if (project != null && !projects.contains(project) && (seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true)) != null && !seamProjects.contains(seamProject)) {
                projects.add(project);
                seamProjects.add(seamProject);
            }
            ++i;
        }
        return seamProjects.toArray(new ISeamProject[seamProjects.size()]);
    }

    public boolean encloses(String resourcePath) {
        return this.fJavaSearchScope == null ? true : this.fJavaSearchScope.encloses(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        return this.fJavaSearchScope == null ? true : this.fJavaSearchScope.encloses(element);
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.fJavaSearchScope == null ? new IPath[]{} : this.fJavaSearchScope.enclosingProjectsAndJars();
    }

    public boolean includesBinaries() {
        return this.fJavaSearchScope == null ? true : this.fJavaSearchScope.includesBinaries();
    }

    public boolean includesClasspaths() {
        return this.fJavaSearchScope == null ? true : this.fJavaSearchScope.includesClasspaths();
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    class ProjectVisitor
    implements IResourceProxyVisitor {
        private HashMap fProjects = new HashMap();
        IJavaSearchScope fScope = null;

        public ProjectVisitor(IJavaSearchScope scope) {
            this.fScope = scope;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (SeamSearchEngine.getInstance().isCanceled()) {
                return false;
            }
            if (proxy.getType() == 4) {
                IProject project = (IProject)proxy.requestResource();
                this.fProjects.put(project.getParent().getFullPath(), project);
                return true;
            }
            return proxy.getType() != 1;
        }

        public IProject[] getProjects() {
            return this.fProjects.values().toArray(new IProject[this.fProjects.size()]);
        }
    }
}

