/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamPackage;

public class SeamJarFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ISeamComponent) {
            return this.isUserDefinedComponent((ISeamComponent)element);
        }
        if (element instanceof ISeamPackage) {
            return this.isUserDefinedPackage((ISeamPackage)element);
        }
        return true;
    }

    boolean isUserDefinedComponent(ISeamComponent c) {
        Set ds = c.getAllDeclarations();
        for (ISeamComponentDeclaration d : ds) {
            IPath path = d.getSourcePath();
            if (path == null || path.toString().endsWith(".jar")) continue;
            return true;
        }
        return false;
    }

    boolean isUserDefinedPackage(ISeamPackage p) {
        for (ISeamComponent c : p.getComponents()) {
            if (!this.isUserDefinedComponent(c)) continue;
            return true;
        }
        for (ISeamComponent c : p.getPackages().values()) {
            if (!this.isUserDefinedPackage((ISeamPackage)c)) continue;
            return true;
        }
        return false;
    }
}

