/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamPackage;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamScope;
import org.jboss.tools.seam.ui.SeamUiImages;
import org.jboss.tools.seam.ui.views.AbstractSeamContentProvider;

public class SeamLabelProvider
extends LabelProvider
implements ICommonLabelProvider {
    private IExtensionStateModel fStateModel;
    private AbstractSeamContentProvider contentProvider;
    boolean isFlatLayout = true;
    boolean isScopeLable = false;
    IPropertyChangeListener scopePropertyListener;
    IPropertyChangeListener layoutPropertyListener;
    JavaElementImageProvider jip = new JavaElementImageProvider();

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        this.fStateModel = commonContentExtensionSite.getExtensionStateModel();
        this.contentProvider = (AbstractSeamContentProvider)commonContentExtensionSite.getExtension().getContentProvider();
        this.scopePropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("seam.scopePresentation".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue();
                    SeamLabelProvider.this.setIsScopeLable(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.scopePropertyListener);
        this.layoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("seam.packageStructure".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue();
                    SeamLabelProvider.this.setIsFlatLayout(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.layoutPropertyListener);
    }

    void setIsFlatLayout(boolean b) {
        this.isFlatLayout = b;
    }

    void setIsScopeLable(boolean b) {
        this.isScopeLable = b;
    }

    public String getText(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return "";
        }
        if (element instanceof ISeamProject) {
            return ((IProjectNature)element).getProject().getName();
        }
        if (element instanceof IProject) {
            return ((IProject)element).getName();
        }
        if (element instanceof ISeamScope) {
            return ((ISeamScope)element).getType().getLabel();
        }
        if (element instanceof ISeamPackage) {
            if (this.isFlatLayout) {
                return ((ISeamPackage)element).getQualifiedName();
            }
            return ((ISeamPackage)element).getName();
        }
        if (element instanceof ISeamComponent) {
            ISeamComponent c = (ISeamComponent)element;
            String name = c.getName();
            int lastIndexOf = name.lastIndexOf(46);
            if (lastIndexOf != -1 && lastIndexOf != name.length()) {
                name = name.substring(lastIndexOf + 1);
            }
            if (this.isScopeLable) {
                name = String.valueOf(name) + " (" + ((ISeamScope)c.getParent()).getType().getLabel() + ")";
            }
            return name;
        }
        if (element instanceof IRole) {
            return ((IRole)element).getName();
        }
        if (element instanceof ISeamFactory) {
            ISeamFactory f = (ISeamFactory)element;
            return String.valueOf(f.getName()) + " - " + f.getSourcePath();
        }
        if (element instanceof IJavaSourceReference) {
            IType type;
            IJavaSourceReference d = (IJavaSourceReference)element;
            IMember m = d.getSourceMember();
            IType iType = type = m instanceof IType ? (IType)m : m.getTypeRoot().findPrimaryType();
            if (type.isBinary()) {
                IResource r = ((ISeamElement)element).getResource();
                String s = r == null ? "<no name>" : r.getName();
                return String.valueOf(s) + "/" + type.getFullyQualifiedName();
            }
            return type.getFullyQualifiedName();
        }
        if (element instanceof ISeamComponentDeclaration) {
            IResource r = ((ISeamComponentDeclaration)element).getResource();
            return r == null ? "???" : r.getName();
        }
        return element == null ? "" : element.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof ISeamProject) {
            return SeamUiImages.PROJECT_IMAGE;
        }
        if (obj instanceof IProject) {
            return SeamUiImages.PROJECT_IMAGE;
        }
        if (obj instanceof ISeamScope) {
            return SeamUiImages.SCOPE_IMAGE;
        }
        if (obj instanceof ISeamPackage) {
            return SeamUiImages.PACKAGE_IMAGE;
        }
        if (obj instanceof ISeamComponent) {
            return SeamUiImages.COMPONENT_IMAGE;
        }
        if (obj instanceof IRole) {
            return SeamUiImages.ROLE_IMAGE;
        }
        if (obj instanceof ISeamFactory) {
            return SeamUiImages.FACTORY_IMAGE;
        }
        if (obj instanceof ISeamJavaComponentDeclaration) {
            ISeamJavaComponentDeclaration d = (ISeamJavaComponentDeclaration)obj;
            IType type = (IType)d.getSourceMember();
            if (type != null) {
                if (type.isBinary()) {
                    return SeamUiImages.JAVA_BINARY_IMAGE;
                }
                return SeamUiImages.JAVA_IMAGE;
            }
            return SeamUiImages.JAVA_IMAGE;
        }
        if (obj instanceof ISeamComponentDeclaration) {
            ISeamComponentDeclaration d = (ISeamComponentDeclaration)obj;
            IResource r = d.getResource();
            if (r != null) {
                return this.jip.getImageLabel((Object)r, 3);
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public String getDescription(Object anElement) {
        return "";
    }

    public void dispose() {
        super.dispose();
        this.fStateModel.removePropertyChangeListener(this.layoutPropertyListener);
        this.fStateModel.removePropertyChangeListener(this.scopePropertyListener);
    }
}

