/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.seam.core.IOpenableElement;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;

public class SeamLinkHelper
implements ILinkHelper {
    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IOpenableElement) {
            ISeamElement e = (ISeamElement)o;
            IPath path = e.getSourcePath();
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (f != null && f.exists() && !"jar".equals(path.getFileExtension())) {
                FileEditorInput fileInput = new FileEditorInput(f);
                IEditorPart editor = null;
                editor = page.findEditor((IEditorInput)fileInput);
                if (editor != null) {
                    page.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                ((IOpenableElement)o).open();
            }
        }
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (anInput instanceof IClassFileEditorInput) {
            ISeamComponent[] cs;
            IClassFile cf = ((IClassFileEditorInput)anInput).getClassFile();
            IJavaProject jp = cf.getJavaProject();
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)jp.getProject(), (boolean)true);
            if (seamProject == null) {
                return null;
            }
            IType type = cf.getType();
            ISeamComponent[] iSeamComponentArray = cs = seamProject.getComponents();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                IMember m;
                ISeamComponent c = iSeamComponentArray[n2];
                ISeamJavaComponentDeclaration d = c.getJavaDeclaration();
                if (d != null && (m = d.getSourceMember()) == type) {
                    return new StructuredSelection((Object)d);
                }
                ++n2;
            }
            return null;
        }
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)file.getProject(), (boolean)true);
        if (seamProject == null) {
            return null;
        }
        Set set = seamProject.getComponentsByPath(file.getFullPath());
        if (set == null || set.isEmpty()) {
            return null;
        }
        ISeamComponent c = (ISeamComponent)set.iterator().next();
        Set ds = c.getAllDeclarations();
        for (ISeamComponentDeclaration d : ds) {
            if (!file.getFullPath().equals((Object)d.getSourcePath())) continue;
            return new StructuredSelection((Object)d);
        }
        return null;
    }
}

