/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamPackage;

public class SeamReferencedFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ISeamComponent) {
            ISeamComponent component = (ISeamComponent)element;
            return SeamReferencedFilter.isComponentDeclaredInThisProject(component);
        }
        if (element instanceof ISeamPackage) {
            ISeamPackage pkg = (ISeamPackage)element;
            return this.isPackageDeclaredInThisProject(pkg);
        }
        return true;
    }

    public static boolean isComponentDeclaredInThisProject(ISeamComponent component) {
        Set ds = component.getAllDeclarations();
        for (ISeamComponentDeclaration d : ds) {
            IResource r = d.getResource();
            if (r == null || !r.exists()) {
                return true;
            }
            if (r == null || r.getProject() != d.getSeamProject().getProject()) continue;
            return true;
        }
        return false;
    }

    boolean isPackageDeclaredInThisProject(ISeamPackage pkg) {
        pkg.getComponents();
        for (ISeamComponent c : pkg.getComponents()) {
            if (!SeamReferencedFilter.isComponentDeclaredInThisProject(c)) continue;
            return true;
        }
        Map ps = pkg.getPackages();
        for (ISeamPackage p : ps.values()) {
            if (!this.isPackageDeclaredInThisProject(p)) continue;
            return true;
        }
        return false;
    }
}

