/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.jboss.tools.common.ui.widget.editor.INamedElement;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetFilterSetFactory;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.wizard.FileMapping;
import org.osgi.service.prefs.BackingStoreException;

public abstract class SeamBaseOperation
extends AbstractOperation {
    public static final String TESTNG_LAUNCH_CONFIG_TYPE_ID = "org.testng.eclipse.launchconfig";
    protected IAdaptable info;
    private Set<File> launchFiles;
    private String launchTemplatePath;
    public static final String[] TEST_NAME_PREFIXES = new String[]{"Test, ....launch", "Test.launch"};

    public SeamBaseOperation(String label) {
        super(label);
    }

    private void putResourceLocationProperty(Map<String, Object> vars, String parameterName, IResource resource) {
        if (resource != null) {
            vars.put(parameterName, resource.getLocation().toFile().toString());
        } else {
            vars.put(parameterName, "");
        }
    }

    private void putResourceLocationProperty(Map<String, Object> vars, String parameterName, String resourcePath) {
        if (resourcePath != null) {
            vars.put(parameterName, resourcePath);
        } else {
            vars.put(parameterName, "");
        }
    }

    private void putPackageLocationProperty(Map<String, Object> vars, String parameterName, String packageName) {
        if (packageName != null) {
            vars.put(parameterName, packageName.replace('.', '/'));
        } else {
            vars.put(parameterName, "");
        }
    }

    /*
     * Loose catch block
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus result;
        block29: {
            result = Status.OK_STATUS;
            this.info = info;
            this.launchFiles = null;
            SeamProjectsSet seamPrjSet = new SeamProjectsSet(this.getProject(info));
            try {
                Map<String, Object> vars = this.loadParameters(info, seamPrjSet);
                List<FileMapping> fileMapping = this.shouldCreateTestLaunch() ? this.getFileMappingsWithTestLaunch(vars) : this.getFileMappings(vars);
                List<String[]> fileMappingCopy = SeamBaseOperation.applyVariables(fileMapping, vars);
                FilterSetCollection filters = this.getFilterSetCollection(vars);
                File[] file = new File[fileMappingCopy.size()];
                int index = 0;
                for (String[] mapping : fileMappingCopy) {
                    file[index] = new File(mapping[1]);
                    FileUtils.getFileUtils().copyFile(new File(mapping[0]), file[index], filters, false);
                    ++index;
                }
                if (this.shouldTouchServer(seamPrjSet)) {
                    WebUtils.changeTimeStamp((IProject)seamPrjSet.getWarProject());
                }
                if (this.launchFiles != null) {
                    for (File launchFile : this.launchFiles) {
                        if (!launchFile.exists()) continue;
                        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                        if (manager instanceof LaunchManager) {
                            ((LaunchManager)manager).importConfigurations(new File[]{launchFile}, monitor);
                        }
                        launchFile.delete();
                    }
                }
            }
            catch (BackingStoreException e) {
                result = new Status(4, "org.jboss.tools.seam.ui", e.getMessage(), (Throwable)e);
                try {
                    IVirtualFile manifest;
                    IProject prj;
                    IVirtualComponent webComp;
                    IContainer viewFolder = seamPrjSet.getViewsFolder();
                    if (viewFolder != null && (webComp = ComponentCore.createComponent((IProject)(prj = seamPrjSet.getWarProject()))) != null && (manifest = webComp.getRootFolder().getFile("/META-INF/MANIFEST.MF")).exists()) {
                        manifest.getUnderlyingFile().getParent().touch(monitor);
                        manifest.getUnderlyingFile().touch(monitor);
                    }
                    seamPrjSet.refreshLocal(monitor);
                }
                catch (CoreException e2) {
                    result = new Status(4, "org.jboss.tools.seam.ui", e2.getMessage(), (Throwable)e2);
                }
                break block29;
            }
            catch (IOException e) {
                result = new Status(4, "org.jboss.tools.seam.ui", e.getMessage(), (Throwable)e);
                break block29;
            }
            catch (CoreException e) {
                result = new Status(4, "org.jboss.tools.seam.ui", e.getMessage(), (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    IVirtualFile manifest;
                    IProject prj;
                    IVirtualComponent webComp;
                    IContainer viewFolder = seamPrjSet.getViewsFolder();
                    if (viewFolder != null && (webComp = ComponentCore.createComponent((IProject)(prj = seamPrjSet.getWarProject()))) != null && (manifest = webComp.getRootFolder().getFile("/META-INF/MANIFEST.MF")).exists()) {
                        manifest.getUnderlyingFile().getParent().touch(monitor);
                        manifest.getUnderlyingFile().touch(monitor);
                    }
                    seamPrjSet.refreshLocal(monitor);
                }
                catch (CoreException e3) {
                    result = new Status(4, "org.jboss.tools.seam.ui", e3.getMessage(), (Throwable)e3);
                }
                break block29;
            }
            {
                finally {
                    try {
                        IVirtualFile manifest;
                        IProject prj;
                        IVirtualComponent webComp;
                        IContainer viewFolder = seamPrjSet.getViewsFolder();
                        if (viewFolder != null && (webComp = ComponentCore.createComponent((IProject)(prj = seamPrjSet.getWarProject()))) != null && (manifest = webComp.getRootFolder().getFile("/META-INF/MANIFEST.MF")).exists()) {
                            manifest.getUnderlyingFile().getParent().touch(monitor);
                            manifest.getUnderlyingFile().touch(monitor);
                        }
                        seamPrjSet.refreshLocal(monitor);
                    }
                    catch (CoreException e) {
                        result = new Status(4, "org.jboss.tools.seam.ui", e.getMessage(), (Throwable)e);
                    }
                }
            }
            try {
                IVirtualFile manifest;
                IProject prj;
                IVirtualComponent webComp;
                IContainer viewFolder = seamPrjSet.getViewsFolder();
                if (viewFolder != null && (webComp = ComponentCore.createComponent((IProject)(prj = seamPrjSet.getWarProject()))) != null && (manifest = webComp.getRootFolder().getFile("/META-INF/MANIFEST.MF")).exists()) {
                    manifest.getUnderlyingFile().getParent().touch(monitor);
                    manifest.getUnderlyingFile().touch(monitor);
                }
                seamPrjSet.refreshLocal(monitor);
            }
            catch (CoreException e) {
                result = new Status(4, "org.jboss.tools.seam.ui", e.getMessage(), (Throwable)e);
            }
        }
        if (result.getSeverity() == 4) {
            SeamGuiPlugin.getDefault().getLog().log(result);
        }
        return result;
    }

    private Map<String, Object> loadParameters(IAdaptable info, SeamProjectsSet seamPrjSet) throws BackingStoreException {
        Map params = (Map)info.getAdapter(Map.class);
        IEclipsePreferences seamFacetPrefs = SeamCorePlugin.getSeamPreferences((IProject)seamPrjSet.getWarProject());
        HashMap<String, Object> vars = new HashMap<String, Object>();
        String[] stringArray = seamFacetPrefs.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            vars.put(key, seamFacetPrefs.get(key, ""));
            ++n2;
        }
        for (Object valueHolder : params.values()) {
            INamedElement elem = (INamedElement)valueHolder;
            vars.put(elem.getName(), elem.getValue().toString());
        }
        this.loadCustomVariables(vars);
        String actionFolder = this.getSessionBeanPackageName(seamFacetPrefs, params);
        String entityFolder = this.getEntityBeanPackageName(seamFacetPrefs, params);
        String testFolder = this.getTestCasesPackageName(seamFacetPrefs, params);
        vars.put("seam.project.instance", seamPrjSet.getWarProject());
        vars.put("seam.home.folder", SeamRuntimeManager.getInstance().getRuntimeForProject(seamPrjSet.getWarProject()).getHomeDir());
        this.putResourceLocationProperty(vars, "seam.project.location", (IResource)seamPrjSet.getWarProject());
        this.putResourceLocationProperty(vars, "seam.project.webcontent", (IResource)seamPrjSet.getViewsFolder());
        this.putResourceLocationProperty(vars, "seam.project.action", (IResource)seamPrjSet.getActionFolder());
        this.putResourceLocationProperty(vars, "seam.project.model", (IResource)seamPrjSet.getModelFolder());
        this.putResourceLocationProperty(vars, "seam.ejb.project.location", (IResource)seamPrjSet.getEjbProject());
        this.putResourceLocationProperty(vars, "seam.test.project.location", (IResource)seamPrjSet.getTestProject());
        this.putResourceLocationProperty(vars, "test.sources", (IResource)seamPrjSet.getTestsFolder());
        this.putPackageLocationProperty(vars, "action.package.path", actionFolder);
        this.putResourceLocationProperty(vars, "action.package", actionFolder);
        this.putPackageLocationProperty(vars, "test.package.path", testFolder);
        this.putResourceLocationProperty(vars, "test.package", testFolder);
        this.putPackageLocationProperty(vars, "model.package.path", entityFolder);
        this.putResourceLocationProperty(vars, "model.package", entityFolder);
        return vars;
    }

    public void openResultInEditor(final IAdaptable info) {
        final IProject project = this.getProject(info);
        final SeamProjectsSet seamPrjSet = new SeamProjectsSet(project);
        Map<String, Object> parameters = null;
        try {
            parameters = this.loadParameters(info, seamPrjSet);
        }
        catch (BackingStoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
            return;
        }
        final Map<String, Object> vars = parameters;
        final List<FileMapping> fileMappings = this.getFileMappings(parameters);
        Display display = Display.getCurrent();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SeamBaseOperation.openResultInEditorInCurrentThread(info, project, seamPrjSet, vars, fileMappings);
                }
            });
        } else {
            SeamBaseOperation.openResultInEditorInCurrentThread(info, project, seamPrjSet, parameters, fileMappings);
        }
    }

    private static void openResultInEditorInCurrentThread(IAdaptable info, IProject project, SeamProjectsSet seamPrjSet, Map<String, Object> parameters, List<FileMapping> fileMappings) {
        try {
            if (!fileMappings.isEmpty()) {
                List<String[]> fileMappingCopy = SeamBaseOperation.applyVariables(fileMappings, parameters);
                IFile iFile = seamPrjSet.getWarProject().getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileMappingCopy.get(0)[1]));
                IDE.openEditor((IWorkbenchPage)SeamGuiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)iFile);
            }
        }
        catch (PartInitException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected boolean shouldTouchServer(SeamProjectsSet seamPrjSet) {
        return !seamPrjSet.isWarConfiguration();
    }

    protected String getSessionBeanPackageName(IEclipsePreferences seamFacetPrefs, Map<String, INamedElement> wizardParams) {
        return seamFacetPrefs.get("action.package", "");
    }

    protected String getEntityBeanPackageName(IEclipsePreferences seamFacetPrefs, Map<String, INamedElement> wizardParams) {
        return seamFacetPrefs.get("model.package", "");
    }

    protected String getTestCasesPackageName(IEclipsePreferences seamFacetPrefs, Map<String, INamedElement> wizardParams) {
        return seamFacetPrefs.get("test.package", "");
    }

    protected IProject getProject(IAdaptable info) {
        Map params = (Map)info.getAdapter(Map.class);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(((INamedElement)params.get("seam.project.name")).getValueAsString());
    }

    public static List<String[]> applyVariables(List<FileMapping> fileMapping, Map<String, Object> vars) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (FileMapping filter : fileMapping) {
            if (!filter.getDeployType().equalsString((String)vars.get("seam.project.deployment.type")) || filter.isTest() && !Boolean.parseBoolean(vars.get("seam.test.creating").toString())) continue;
            String source = filter.getSource();
            for (String property : vars.keySet()) {
                if (!source.contains("${" + property.toString() + "}")) continue;
                source = source.replace("${" + property.toString() + "}", vars.get(property.toString()).toString());
            }
            String dest = filter.getDestination();
            for (String property : vars.keySet()) {
                if (!dest.contains("${" + property.toString() + "}")) continue;
                dest = dest.replace("${" + property.toString() + "}", vars.get(property.toString()).toString());
            }
            result.add(new String[]{source, dest});
        }
        return result;
    }

    public abstract List<FileMapping> getFileMappings(Map<String, Object> var1);

    protected abstract boolean shouldCreateTestLaunch();

    protected List<FileMapping> getFileMappingsWithTestLaunch(Map<String, Object> vars) {
        ArrayList<FileMapping> mapping = new ArrayList<FileMapping>();
        mapping.addAll(this.getFileMappings(vars));
        this.launchFiles = new HashSet<File>();
        String[] stringArray = TEST_NAME_PREFIXES;
        int n = TEST_NAME_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String namePrefix = vars.get("interface.name") + prefix;
            this.addTestLaunchToFileMapping(mapping, namePrefix);
            ++n2;
        }
        return mapping;
    }

    protected List<FileMapping> addTestLaunchToFileMapping(List<FileMapping> mapping, String namePrefix) {
        String launchName = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(namePrefix);
        try {
            File launchFile = new File(SeamCorePlugin.getDefault().getStateLocation().toFile(), ".testNGlaunches/" + launchName);
            this.launchFiles.add(launchFile);
            if (launchFile.exists()) {
                launchFile.delete();
            }
            if (this.launchTemplatePath == null) {
                this.launchTemplatePath = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "/testng/testng.launch").getAbsolutePath();
            }
            mapping.add(new FileMapping(this.launchTemplatePath, launchFile.getAbsolutePath(), FileMapping.TYPE.EAR, true));
            mapping.add(new FileMapping(this.launchTemplatePath, launchFile.getAbsolutePath(), FileMapping.TYPE.WAR, true));
        }
        catch (IOException e) {
            SeamGuiPlugin.getDefault().logError(e);
        }
        return mapping;
    }

    public FilterSetCollection getFilterSetCollection(Map<String, Object> vars) {
        return new FilterSetCollection(SeamFacetFilterSetFactory.createFiltersFilterSet(vars));
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    public File getSeamFolder(Map<String, Object> vars) {
        return new File(vars.get("seam.home.folder").toString(), "seam-gen");
    }

    protected void loadCustomVariables(Map<String, Object> vars) {
    }
}

