/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.internal.core.validation.SeamProjectPropertyValidator;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;

public abstract class SeamBaseWizardPage
extends WizardPage
implements IAdaptable,
PropertyChangeListener {
    protected final IStructuredSelection initialSelection;
    protected IProject rootSeamProject;
    Map<String, IFieldEditor> editorRegistry = new HashMap<String, IFieldEditor>();
    List<IFieldEditor> editorOrder = new ArrayList<IFieldEditor>();

    public SeamBaseWizardPage(String pageName, String title, ImageDescriptor titleImage, IStructuredSelection initialSelection) {
        super(pageName, title, titleImage);
        this.initialSelection = initialSelection;
        this.createEditors();
    }

    protected SeamBaseWizardPage(String pageName, IStructuredSelection initSelection) {
        super(pageName);
        this.initialSelection = initSelection;
        this.createEditors();
    }

    protected void createEditors() {
        this.addEditors(SeamWizardFactory.createBaseFormFieldEditors(SeamWizardUtils.getRootSeamProjectName((ISelection)this.initialSelection)));
        this.rootSeamProject = SeamWizardUtils.getRootSeamProject((ISelection)this.initialSelection);
        String selectedProject = this.rootSeamProject == null ? "" : this.rootSeamProject.getName();
        String packageName = this.getDefaultPackageName(selectedProject);
        this.addEditor(SeamWizardFactory.createSeamJavaPackageSelectionFieldEditor(packageName));
        this.setSeamProjectNameData(selectedProject);
    }

    public void createControl(Composite parent) {
        this.setControl((Control)new GridLayoutComposite(parent));
        if (!"".equals(this.editorRegistry.get("seam.project.name").getValue())) {
            Map errors = SeamValidatorFactory.SEAM_PROJECT_NAME_VALIDATOR.validate(this.getEditor("seam.project.name").getValue(), null);
            if (!errors.isEmpty()) {
                this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
                this.getEditor("bean.name").setEnabled(false);
            } else if (this.isWar()) {
                this.getEditor("bean.name").setEnabled(false);
                LabelFieldEditor label = (LabelFieldEditor)((CompositeEditor)this.getEditor("interface.name")).getEditors().get(0);
                label.getLabelControl().setText(SeamCoreMessages.SEAM_BASE_WIZARD_PAGE_POJO_CLASS_NAME);
            } else {
                this.getEditor("bean.name").setEnabled(true);
            }
        } else {
            this.getEditor("bean.name").setEnabled(false);
            if (this.getEditor("seam.package.name") != null) {
                this.getEditor("seam.package.name").setEnabled(false);
            }
        }
        String selectdProject = this.getEditor("seam.project.name").getValueAsString();
        if (selectdProject != null && !"".equals(selectdProject) && this.isValidProjectSelected()) {
            this.isValidRuntimeConfigured(this.getSelectedProject());
        }
        this.setPageComplete(false);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Map.class) {
            return this.editorRegistry;
        }
        return null;
    }

    public void addEditor(IFieldEditor editor) {
        this.editorRegistry.put(editor.getName(), editor);
        this.editorOrder.add(editor);
        editor.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void addEditors(IFieldEditor[] editors) {
        IFieldEditor[] iFieldEditorArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IFieldEditor fieldEditor = iFieldEditorArray[n2];
            this.addEditor(fieldEditor);
            ++n2;
        }
    }

    public IFieldEditor getEditor(String name) {
        return this.editorRegistry.get(name);
    }

    public void setDefaultValue(String name, Object value) {
        IFieldEditor editor = this.getEditor(name);
        editor.removePropertyChangeListener((PropertyChangeListener)this);
        editor.setValue(value);
        editor.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("seam.project.name".equals(event.getPropertyName())) {
            this.rootSeamProject = SeamWizardUtils.getRootSeamProject(this.getSelectedProject());
        }
        this.doFillDefaults(event);
        this.doValidate(event);
    }

    protected void doValidate(PropertyChangeEvent event) {
        if (!this.isValidProjectSelected()) {
            return;
        }
        IProject project = this.getSelectedProject();
        boolean isWar = this.isWar();
        this.getEditor("bean.name").setEnabled(!isWar);
        IFieldEditor packageEditor = this.getEditor("seam.package.name");
        if (packageEditor != null) {
            packageEditor.setEnabled(true);
        }
        if (!this.isValidRuntimeConfigured(project)) {
            return;
        }
        LabelFieldEditor label = (LabelFieldEditor)((CompositeEditor)this.getEditor("interface.name")).getEditors().get(0);
        label.getLabelControl().setText(isWar ? SeamCoreMessages.SEAM_BASE_WIZARD_PAGE_POJO_CLASS_NAME : SeamCoreMessages.SEAM_BASE_WIZARD_PAGE_LOCAL_CLASS_NAME);
        Map errors = SeamValidatorFactory.SEAM_COMPONENT_NAME_VALIDATOR.validate(this.editorRegistry.get("component.name").getValue(), null);
        if (!errors.isEmpty()) {
            this.setErrorMessage(NLS.bind((String)((IStatus)errors.get("default.error")).getMessage(), (Object)SeamCoreMessages.SEAM_BASE_WIZARD_PAGE_SEAM_COMPONENTS));
            this.setPageComplete(false);
            return;
        }
        errors = SeamValidatorFactory.SEAM_COMPONENT_NAME_VALIDATOR.validate(this.editorRegistry.get("interface.name").getValue(), null);
        if (!errors.isEmpty()) {
            this.setErrorMessage(NLS.bind((String)((IStatus)errors.get("default.error")).getMessage(), (Object)SeamCoreMessages.SEAM_BASE_WIZARD_PAGE_LOCAL_INTERFACE));
            this.setPageComplete(false);
            return;
        }
        if (!isWar && !(errors = SeamValidatorFactory.SEAM_COMPONENT_NAME_VALIDATOR.validate(this.editorRegistry.get("bean.name").getValue(), null)).isEmpty()) {
            this.setErrorMessage(NLS.bind((String)((IStatus)errors.get("default.error")).getMessage(), (Object)"Bean"));
            this.setPageComplete(false);
            return;
        }
        IFieldEditor editor = this.editorRegistry.get("seam.package.name");
        if (editor != null && !(errors = SeamValidatorFactory.PACKAGE_NAME_VALIDATOR.validate(editor.getValue(), null)).isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return;
        }
        errors = SeamValidatorFactory.SEAM_METHOD_NAME_VALIDATOR.validate(this.editorRegistry.get("method.name").getValue(), (Object)new Object[]{"Method", project});
        if (!errors.isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return;
        }
        errors = SeamValidatorFactory.FILE_NAME_VALIDATOR.validate(this.editorRegistry.get("page.name").getValue(), (Object)new Object[]{"Page", project});
        if (!errors.isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return;
        }
        errors = SeamValidatorFactory.SEAM_JAVA_INTEFACE_NAME_CONVENTION_VALIDATOR.validate(this.editorRegistry.get("interface.name").getValue(), (Object)new Object[]{SeamCoreMessages.SEAM_BASE_WIZARD_PAGE_LOCAL_INTERFACE, project});
        if (!errors.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(((IStatus)errors.get("default.error")).getMessage(), 2);
            this.setPageComplete(true);
            return;
        }
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                IType component = javaProject.findType(String.valueOf((String)this.editorRegistry.get("seam.package.name").getValue()) + "." + this.editorRegistry.get("interface.name").getValue());
                if (component != null) {
                    this.setErrorMessage(null);
                    this.setMessage(SeamCoreMessages.POJO_CLASS_ALREADY_EXISTS, 2);
                    this.setPageComplete(true);
                    return;
                }
            }
            catch (JavaModelException ex) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
        SeamProjectsSet seamPrjSet = new SeamProjectsSet(project);
        IPath webContent = seamPrjSet.getViewsFolder().getFullPath();
        IPath page = webContent.append(this.editorRegistry.get("page.name").getValue() + ".xhtml");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(page);
        if (file.exists()) {
            this.setErrorMessage(null);
            this.setMessage(SeamCoreMessages.PAGE_ALREADY_EXISTS, 2);
            this.setPageComplete(true);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(this.getDefaultMessageText());
        this.setPageComplete(true);
    }

    protected boolean isProjectSettingsOk() {
        if (this.rootSeamProject != null) {
            IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)this.rootSeamProject);
            return SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("action.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("seam.project.web.root.folder", ""), (boolean)false) && ("false".equals(prefs.get("seam.test.creating", "false").trim()) || SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("test.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isProjectNameValid((String)prefs.get("seam.test.project", ""), (boolean)false)) && ("war".equals(prefs.get("seam.project.deployment.type", "war").trim()) || SeamProjectPropertyValidator.isProjectNameValid((String)prefs.get("seam.ejb.project", ""), (boolean)false));
        }
        return true;
    }

    protected boolean isValidRuntimeConfigured(IProject project) {
        String seamRt = SeamCorePlugin.getSeamPreferences((IProject)project).get("seam.runtime.name", "");
        Map errors = SeamValidatorFactory.SEAM_RUNTIME_VALIDATOR.validate((Object)seamRt, null);
        if (!errors.isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    protected boolean isValidProjectSelected() {
        Map errors = SeamValidatorFactory.SEAM_PROJECT_NAME_VALIDATOR.validate(this.editorRegistry.get("seam.project.name").getValue(), null);
        if (!errors.isEmpty() || !this.isProjectSettingsOk()) {
            IFieldEditor packageEditor;
            IStatus errorStatus = (IStatus)errors.get("default.error");
            String errorMessage = SeamCoreMessages.VALIDATOR_INVALID_SETTINGS;
            if (errorStatus != null) {
                errorMessage = errorStatus.getMessage();
            }
            this.setErrorMessage(errorMessage);
            this.setPageComplete(false);
            IFieldEditor beanEditor = this.getEditor("bean.name");
            if (beanEditor != null) {
                beanEditor.setEnabled(false);
            }
            if ((packageEditor = this.getEditor("seam.package.name")) != null) {
                packageEditor.setEnabled(false);
            }
            return false;
        }
        return true;
    }

    protected void doFillDefaults(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("component.name") || event.getPropertyName().equals("seam.project.name")) {
            String value = this.getEditor("component.name").getValueAsString();
            if (value == null || "".equals(value)) {
                this.setDefaultValue("component.name", "");
                this.setDefaultValue("interface.name", "");
                this.setDefaultValue("bean.name", "");
                this.setDefaultValue("method.name", "");
                this.setDefaultValue("page.name", "");
            } else {
                String valueU = String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1);
                this.setDefaultValue("interface.name", valueU);
                this.setDefaultValue("bean.name", String.valueOf(valueU) + "Bean");
                String valueL = String.valueOf(value.substring(0, 1).toLowerCase()) + value.substring(1);
                this.setDefaultValue("method.name", valueL);
                this.setDefaultValue("page.name", valueL);
            }
        }
        if (event.getPropertyName().equals("seam.project.name") && this.getEditor("seam.package.name") != null) {
            String selectedProject = event.getNewValue().toString();
            this.setSeamProjectNameData(selectedProject);
            this.setDefaultValue("seam.package.name", this.getDefaultPackageName(selectedProject));
        }
    }

    protected String getDefaultPackageName(String selectedProject) {
        IProject project;
        String packageName = "";
        if (selectedProject != null && selectedProject.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(selectedProject)) != null) {
            IEclipsePreferences seamFacetPrefs = SeamCorePlugin.getSeamPreferences((IProject)project);
            packageName = this.getDefaultPackageName(seamFacetPrefs);
        }
        return packageName;
    }

    protected String getDefaultPackageName(IEclipsePreferences seamFacetPrefs) {
        return seamFacetPrefs.get("action.package", "");
    }

    protected void setSeamProjectNameData(String projectName) {
        IFieldEditor editor = this.getEditor("seam.package.name");
        if (editor != null) {
            editor.setData((Object)"seam.project.name", (Object)projectName);
        }
    }

    public IProject getSelectedProject() {
        IResource project;
        String projectName = this.editorRegistry.get("seam.project.name").getValueAsString();
        if (projectName != null && projectName.trim().length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName)) != null && project instanceof IProject) {
            return (IProject)project;
        }
        return null;
    }

    public boolean isWar() {
        if (this.getSelectedProject() == null || SeamCorePlugin.getSeamPreferences((IProject)this.getSelectedProject().getProject()) == null) {
            return true;
        }
        return "war".equals(SeamCorePlugin.getSeamPreferences((IProject)this.getSelectedProject().getProject()).get("seam.project.deployment.type", "war"));
    }

    public String getRootSeamProject() {
        return this.rootSeamProject != null ? this.rootSeamProject.getName() : null;
    }

    public abstract String getDefaultMessageText();

    public class GridLayoutComposite
    extends Composite {
        public GridLayoutComposite(Composite parent, int style) {
            super(parent, style);
            int columnNumber = 1;
            for (IFieldEditor fieldEditor : SeamBaseWizardPage.this.editorOrder) {
                if (fieldEditor.getNumberOfControls() <= columnNumber) continue;
                columnNumber = fieldEditor.getNumberOfControls();
            }
            GridLayout gl = new GridLayout(columnNumber, false);
            gl.verticalSpacing = 5;
            gl.marginTop = 3;
            gl.marginLeft = 3;
            gl.marginRight = 3;
            this.setLayout((Layout)gl);
            for (IFieldEditor fieldEditor2 : SeamBaseWizardPage.this.editorOrder) {
                fieldEditor2.doFillIntoGrid((Object)this);
            }
        }

        public GridLayoutComposite(Composite parent) {
            this(parent, 0);
        }
    }
}

