/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.hibernate.eclipse.console.model.IConsoleConfigurationNameProvider;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.model.impl.ReverseEngineeringDefinitionImpl;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.ui.views.DBTableFilterView;
import org.jboss.tools.seam.ui.wizard.SeamGenerateEntitiesWizardPage;

public class SeamGenerateEntitiesTablesWizardPage
extends WizardPage {
    public static final String pageName = "seam.generate.entities.tablesPage";
    private String cfgName;
    private IReverseEngineeringDefinition model;

    public SeamGenerateEntitiesTablesWizardPage() {
        super(pageName, SeamCoreMessages.GENERATE_SEAM_ENTITIES_WIZARD_TITLE, null);
        this.setMessage("Select Tables");
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new FillLayout());
        DBTableFilterView tfView = new DBTableFilterView(top, 0){

            protected String getConsoleConfigurationName() {
                return SeamGenerateEntitiesTablesWizardPage.this.cfgName;
            }
        };
        this.model = new ReverseEngineeringDefinitionImpl(new IConsoleConfigurationNameProvider(){

            public String getConsoleConfigurationName() {
                return SeamGenerateEntitiesTablesWizardPage.this.cfgName;
            }
        });
        tfView.setModel(this.model);
        if (this.getWizard().getContainer() instanceof WizardDialog) {
            WizardDialog wd = (WizardDialog)this.getWizard().getContainer();
            wd.addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (event.getSelectedPage() == SeamGenerateEntitiesTablesWizardPage.this) {
                        SeamGenerateEntitiesWizardPage page1 = (SeamGenerateEntitiesWizardPage)SeamGenerateEntitiesTablesWizardPage.this.getWizard().getPreviousPage((IWizardPage)SeamGenerateEntitiesTablesWizardPage.this);
                        SeamGenerateEntitiesTablesWizardPage.this.cfgName = page1.getConsoleCongigurationName();
                    }
                }
            });
        }
        this.setControl((Control)top);
    }

    public String getFilters() {
        StringBuilder builder = new StringBuilder();
        if (this.model != null) {
            ITableFilter[] filters = this.model.getTableFilters();
            if (filters.length == 0) {
                return builder.toString();
            }
            builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n").append("<!DOCTYPE hibernate-reverse-engineering PUBLIC \"-//Hibernate/Hibernate Reverse Engineering DTD 3.0//EN\"").append(" \"http://hibernate.sourceforge.net/hibernate-reverse-engineering-3.0.dtd\" >\r\n").append("\r\n").append("<hibernate-reverse-engineering>\r\n");
            ITableFilter[] iTableFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ITableFilter element = iTableFilterArray[n2];
                builder.append(this.generateStringForFilter(element));
                ++n2;
            }
            builder.append("</hibernate-reverse-engineering>\r\n");
        }
        return builder.toString();
    }

    private String generateStringForFilter(ITableFilter filter) {
        String filterStr = "<table-filter match-name=\"" + filter.getMatchName() + "\"";
        if (filter.getMatchSchema() != null) {
            filterStr = String.valueOf(filterStr) + " match-schema=\"" + filter.getMatchSchema() + "\"";
        }
        if (filter.getMatchCatalog() != null) {
            filterStr = String.valueOf(filterStr) + " match-catalog=\"" + filter.getMatchCatalog() + "\"";
        }
        if (filter.getExclude().booleanValue()) {
            filterStr = String.valueOf(filterStr) + " exclude=\"true\"";
        }
        filterStr = String.valueOf(filterStr) + "></table-filter>\r\n";
        return filterStr;
    }
}

