/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.tools.jst.web.server.RegistrationHelper;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.ResourceDeployer;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetProjectCreationDataModelProvider;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.internal.project.facet.SeamInstallWizardPage;
import org.jboss.tools.seam.ui.wizard.SeamFormWizard;

public class SeamProjectWizard
extends WebProjectWizard
implements IExecutableExtension {
    private SeamWebProjectFirstPage firstPage;
    private String seamConfigTemplate;
    private Combo matchedServerTargetCombo;
    private Control[] dependentServerControls;
    private Combo serverRuntimeTargetCombo;
    private IPreset oldPreset;
    static final String templateJstSeam1 = "template.jst.seam";
    static final String templateJstSeam2 = "template.jst.seam2";
    static final String templateJstSeam21 = "template.jst.seam21";
    static final String templateJstSeam22 = "template.jst.seam22";
    static final String templateJstSeam23 = "template.jst.seam23";
    private static final Map<String, String> templates = new HashMap<String, String>();
    IFacetedProject.Action action = null;

    static {
        templates.put("jst.seam.preset", templateJstSeam1);
        templates.put("jst.seam2.preset", templateJstSeam2);
        templates.put("jst.seam21.preset", templateJstSeam21);
        templates.put("jst.seam22.preset", templateJstSeam22);
        templates.put("jst.seam23.preset", templateJstSeam23);
    }

    public SeamProjectWizard() {
        this.setWindowTitle(SeamCoreMessages.SEAM_PROJECT_WIZARD_NEW_SEAM_PROJECT);
    }

    public SeamProjectWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(SeamCoreMessages.SEAM_PROJECT_WIZARD_NEW_SEAM_PROJECT);
    }

    protected IDataModel createDataModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)new SeamFacetProjectCreationDataModelProvider());
    }

    protected IWizardPage createFirstPage() {
        this.firstPage = new SeamWebProjectFirstPage(this.model, "first.page");
        this.firstPage.setImageDescriptor(ImageDescriptor.createFromFile(SeamFormWizard.class, (String)"SeamWebProjectWizBan.png"));
        this.firstPage.setTitle(SeamCoreMessages.SEAM_PROJECT_WIZARD_SEAM_WEB_PROJECT);
        this.firstPage.setDescription(SeamCoreMessages.SEAM_PROJECT_WIZARD_CREATE_STANDALONE_SEAM_WEB_PROJECT);
        return this.firstPage;
    }

    private void setSeamConfigTemplate(String seamConfigTemplate) {
        this.seamConfigTemplate = seamConfigTemplate;
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        this.synchSeamActionModels();
        this.getFacetedProjectWorkingCopy().addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                SeamProjectWizard.this.synchSeamActionModels();
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        this.getFacetedProjectWorkingCopy().addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                IPreset preset = SeamProjectWizard.this.getFacetedProjectWorkingCopy().getSelectedPreset();
                if (preset != null) {
                    Set facets = preset.getProjectFacets();
                    for (IProjectFacetVersion facet : facets) {
                        if (!"jst.seam".equals(facet.getProjectFacet().getId())) continue;
                        SeamProjectWizard.this.oldPreset = null;
                        break;
                    }
                    SeamProjectWizard.this.setSeamConfigTemplate((String)templates.get(preset.getId()));
                }
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED});
        this.getFacetedProjectWorkingCopy().addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                Set actions = SeamProjectWizard.this.getFacetedProjectWorkingCopy().getProjectFacetActions();
                for (IFacetedProject.Action action : actions) {
                    if (!"jst.seam".equals(action.getProjectFacetVersion().getProjectFacet().getId())) continue;
                    IDataModel seamFacetModel = (IDataModel)action.getConfig();
                    seamFacetModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", SeamProjectWizard.this.model.getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"));
                }
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_NAME_CHANGED});
        Control control = this.findGroupByText((Composite)this.getShell(), SeamCoreMessages.SEAM_PROJECT_WIZARD_EAR_MEMBERSHIP);
        if (control != null) {
            control.setVisible(false);
        }
        this.firstPage.isPageComplete();
    }

    protected void setRuntimeAndDefaultFacets(IRuntime runtime) {
        IPreset preset = this.getFacetedProjectWorkingCopy().getSelectedPreset();
        if (preset != null) {
            this.oldPreset = preset;
        }
        IFacetedProjectWorkingCopy dm = this.getFacetedProjectWorkingCopy();
        dm.setTargetedRuntimes(Collections.emptySet());
        boolean dontUseRuntimeConfig = false;
        if (runtime != null) {
            if (this.oldPreset != null) {
                dm.setProjectFacets(this.oldPreset.getProjectFacets());
                dontUseRuntimeConfig = true;
            } else {
                HashSet<IProjectFacetVersion> minFacets = new HashSet<IProjectFacetVersion>();
                try {
                    for (IProjectFacet f : dm.getFixedProjectFacets()) {
                        minFacets.add(f.getLatestSupportedVersion(runtime));
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                dm.setProjectFacets(minFacets);
            }
            dm.setTargetedRuntimes(Collections.singleton(runtime));
        }
        if (dontUseRuntimeConfig) {
            if (dm.getAvailablePresets().contains(this.oldPreset)) {
                dm.setSelectedPreset(this.oldPreset.getId());
            }
        } else if (dm.getAvailablePresets().contains("default.configuration")) {
            dm.setSelectedPreset("default.configuration");
        }
    }

    private void synchSeamActionModels() {
        Set actions = this.getFacetedProjectWorkingCopy().getProjectFacetActions();
        for (IFacetedProject.Action action : actions) {
            Object targetRuntime;
            IDataModel model;
            if (!"jst.seam".equals(action.getProjectFacetVersion().getProjectFacet().getId()) || (model = (IDataModel)action.getConfig()) == null) continue;
            Object targetServer = this.model.getProperty("seam.project.deployment.target");
            if (targetServer != null) {
                model.setProperty("seam.project.deployment.target", targetServer);
            }
            if ((targetRuntime = this.model.getProperty("seam.project.deployment.runtime")) != null) {
                Object targetRuntimeName = targetRuntime;
                if (targetRuntime instanceof IRuntime) {
                    targetRuntimeName = ((IRuntime)targetRuntime).getName();
                }
                model.setProperty("seam.project.deployment.runtime", targetRuntimeName);
            }
            final DataModelSynchHelper synchHelper = this.firstPage.initializeSynchHelper(model);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    synchHelper.synchCombo(SeamProjectWizard.this.matchedServerTargetCombo, "seam.project.deployment.target", SeamProjectWizard.this.dependentServerControls);
                    synchHelper.synchCombo(SeamProjectWizard.this.serverRuntimeTargetCombo, "seam.project.deployment.runtime", null);
                }
            });
        }
    }

    Control findControlByClass(Composite comp, Class claz) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control;
            Control child = controlArray[n2];
            if (child.getClass() == claz) {
                return child;
            }
            if (child instanceof Composite && (control = this.findControlByClass((Composite)child, claz)) != null) {
                return control;
            }
            ++n2;
        }
        return null;
    }

    Control findGroupByText(Composite comp, String text) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control;
            Control child = controlArray[n2];
            if (child instanceof Group && ((Group)child).getText().equals(text)) {
                return child;
            }
            if (child instanceof Composite && (control = this.findGroupByText((Composite)child, text)) != null) {
                return control;
            }
            ++n2;
        }
        return null;
    }

    protected String getFinalPerspectiveID() {
        return null;
    }

    protected IFacetedProjectTemplate getTemplate() {
        this.seamConfigTemplate = SeamCorePlugin.getDefault().getPluginPreferences().getString("org.jboss.tools.seam.core.project.facet.config.template");
        if (this.seamConfigTemplate == null || this.seamConfigTemplate.length() == 0) {
            SeamRuntime runtime = SeamRuntimeManager.getInstance().getLatestSeamRuntime();
            this.seamConfigTemplate = runtime != null ? (runtime.getVersion() == SeamVersion.SEAM_1_2 ? templateJstSeam1 : (runtime.getVersion() == SeamVersion.SEAM_2_0 ? templateJstSeam2 : (runtime.getVersion() == SeamVersion.SEAM_2_1 ? templateJstSeam21 : (runtime.getVersion() == SeamVersion.SEAM_2_3 ? templateJstSeam23 : templateJstSeam22)))) : templateJstSeam22;
        }
        return ProjectFacetsManager.getTemplate((String)this.seamConfigTemplate);
    }

    public boolean performFinish() {
        SeamInstallWizardPage page = (SeamInstallWizardPage)this.getPage(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_FACET);
        page.finishPressed();
        IDataModel model = page.getConfig();
        model.setProperty("create.ear.projects", (Object)Boolean.TRUE);
        boolean isEAR = "ear".equalsIgnoreCase(model.getStringProperty("seam.project.deployment.type"));
        IFacetedProjectWorkingCopy fpwc = this.getFacetedProjectWorkingCopy();
        IProjectFacet jpaFacet = ProjectFacetsManager.getProjectFacet((String)"jpt.jpa");
        IProjectFacetVersion pfv = fpwc.getProjectFacetVersion(jpaFacet);
        if (isEAR && pfv != null) {
            this.action = fpwc.getProjectFacetAction(jpaFacet);
            IDataModel dataModel = (IDataModel)this.action.getConfig();
            String connectionProfileName = dataModel.getStringProperty("JpaFacetDataModelProperties.CONNECTION");
            if (connectionProfileName == null) {
                throw new NullPointerException("Jpa connection profile is null");
            }
            page.setJpaConnectionProfile(connectionProfileName);
            fpwc.removeProjectFacet(jpaFacet);
        }
        return super.performFinish();
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        IProject warProject = this.getFacetedProject().getProject();
        SeamInstallWizardPage page = (SeamInstallWizardPage)this.getPage(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_FACET);
        IDataModel model = page.getConfig();
        boolean deployAsEar = "ear".equals(model.getProperty("seam.project.deployment.type"));
        IProject earProject = null;
        IProject ejbProject = null;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        String parentProjectName = String.valueOf(warProject.getName()) + "-parent";
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject parentProject = wsRoot.getProject(parentProjectName);
        if (parentProject != null && parentProject.exists()) {
            projects.add(parentProject);
        }
        projects.add(warProject);
        if (deployAsEar) {
            String ejbProjectName = model.getStringProperty("seam.ejb.project");
            String earProjectName = model.getStringProperty("seam.ear.project");
            earProject = wsRoot.getProject(earProjectName);
            ejbProject = wsRoot.getProject(ejbProjectName);
            projects.add(ejbProject);
            projects.add(earProject);
        }
        if (ejbProject != null) {
            this.provideClassPath(projects, ejbProject);
            if (this.action != null) {
                IFile hibernateLaunchFile;
                IDataModel jpaModel = (IDataModel)this.action.getConfig();
                boolean isHibernatePlatform = "hibernate".equals(jpaModel.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID"));
                if (isHibernatePlatform && (hibernateLaunchFile = ejbProject.getFile(String.valueOf(ejbProject.getName()) + ".launch")).exists()) {
                    hibernateLaunchFile.delete(1, monitor);
                }
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ejbProject, (boolean)true, null);
                facetedProject.installProjectFacet(this.action.getProjectFacetVersion(), this.action.getConfig(), null);
            }
        }
        this.buildProjects(projects, monitor);
        IServer server = SeamFacetAbstractInstallDelegate.getServer((IDataModel)model);
        if (server != null) {
            String[] driverJars;
            IDeployableServer jbs = (IDeployableServer)server.loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
            if (jbs != null && (driverJars = (String[])model.getProperty("driver.files.array")) != null) {
                String configFolder = jbs.getConfigDirectory();
                if (model.getStringProperty("seam.runtime.library.provider").equals(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_COPY_LIBRARIES)) {
                    AntCopyUtils.copyFiles((String[])driverJars, (File)new File(configFolder, "lib"), (boolean)false);
                }
            }
            IPath filePath = new Path("resources").append(String.valueOf(warProject.getName()) + "-ds.xml");
            ResourceDeployer dsJob = null;
            dsJob = deployAsEar ? new ResourceDeployer(earProject, server, filePath) : new ResourceDeployer(warProject, server, filePath);
            dsJob.setNextJob((Job)RegistrationHelper.getRegisterInServerJob((IProject)warProject, (IServer[])new IServer[]{server}, null));
            dsJob.schedule();
        }
    }

    private void provideClassPath(List<IProject> projects, IProject ejbProject) throws CoreException {
        if (ejbProject == null) {
            return;
        }
        int k = 0;
        while (k < 50) {
            ++k;
            J2EEComponentClasspathUpdater.getInstance().forceUpdate(projects, false);
            try {
                boolean ok = SeamProjectWizard.checkClassPath(ejbProject);
                if (ok) {
                }
            }
            catch (CoreException coreException) {}
            break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean checkClassPath(IProject project) throws CoreException {
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] es = javaProject.getRawClasspath();
        int i = 0;
        while (i < es.length) {
            IPath p;
            if (es[i].getEntryKind() == 5 && (p = es[i].getPath()).toString().startsWith("org.eclipse.jst.j2ee")) {
                IClasspathContainer c = JavaCore.getClasspathContainer((IPath)p, (IJavaProject)javaProject);
                if (c == null) {
                    return false;
                }
                IClasspathEntry[] cs = c.getClasspathEntries();
                return cs != null && cs.length > 0;
            }
            ++i;
        }
        return true;
    }

    private void buildProjects(List<IProject> projects, IProgressMonitor monitor) {
        J2EEComponentClasspathUpdater.getInstance().forceUpdate(projects, false);
        try {
            for (IProject project : projects) {
                project.build(15, monitor);
                project.build(6, monitor);
            }
        }
        catch (CoreException e) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    class SeamWebProjectFirstPage
    extends WebProjectFirstPage {
        private final String eapRuntimeId = "org.jboss.ide.eclipse.as.runtime.eap.";
        private String lastWeb25Template;
        private int lastWeb25ComboIndex;

        protected String getInfopopID() {
            return "org.jboss.tools.seam.ui.new_seam_project";
        }

        public SeamWebProjectFirstPage(IDataModel model, String pageName) {
            super(model, pageName);
            this.eapRuntimeId = "org.jboss.ide.eclipse.as.runtime.eap.";
        }

        protected Composite createTopLevelComposite(Composite parent) {
            Composite top = new Composite(parent, 0);
            top.setLayout((Layout)new GridLayout());
            top.setLayoutData((Object)new GridData(1808));
            this.createProjectGroup(top);
            this.createServerTargetComposite(top);
            SeamProjectWizard.this.serverRuntimeTargetCombo = this.serverTargetCombo;
            this.createPrimaryFacetComposite(top);
            this.createSeamServerTargetComposite(top);
            this.createPresetPanel(top);
            return top;
        }

        protected void updatePrimaryVersions() {
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            IProjectFacetVersion selectedVersion = fpjwc.getProjectFacetVersion(this.primaryProjectFacet);
            SortedSet initialVersions = fpjwc.getAvailableVersions(this.primaryProjectFacet);
            String[] items = new String[initialVersions.size()];
            int i = 0;
            int selectedVersionIndex = -1;
            Iterator iterator = initialVersions.iterator();
            while (iterator.hasNext()) {
                items[i] = ((IProjectFacetVersion)iterator.next()).getVersionString();
                if (selectedVersionIndex == -1 && items[i].equals(selectedVersion.getVersionString())) {
                    selectedVersionIndex = i;
                }
                ++i;
            }
            this.primaryVersionCombo.clearSelection();
            this.primaryVersionCombo.setItems(items);
            if (!this.setWebModuleVersion()) {
                this.primaryVersionCombo.select(selectedVersionIndex);
            }
        }

        protected void createSeamServerTargetComposite(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(SeamCoreMessages.SEAM_TARGET_SERVER);
            group.setLayoutData((Object)SeamWebProjectFirstPage.gdhfill());
            group.setLayout((Layout)new GridLayout(2, false));
            SeamProjectWizard.this.matchedServerTargetCombo = new Combo((Composite)group, 2056);
            SeamProjectWizard.this.matchedServerTargetCombo.setLayoutData((Object)SeamWebProjectFirstPage.gdhfill());
            Button newMatchedServerTargetButton = new Button((Composite)group, 0);
            newMatchedServerTargetButton.setText(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_NEW);
            newMatchedServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SeamWebProjectFirstPage.this.internalLaunchNewServerWizard(SeamWebProjectFirstPage.this.getShell(), SeamWebProjectFirstPage.this.model);
                }
            });
            SeamProjectWizard.this.dependentServerControls = new Control[]{this.serverTargetCombo, newMatchedServerTargetButton};
            this.synchHelper.synchCombo(SeamProjectWizard.this.matchedServerTargetCombo, "seam.project.deployment.target", SeamProjectWizard.this.dependentServerControls);
            if (SeamProjectWizard.this.matchedServerTargetCombo.getSelectionIndex() == -1 && SeamProjectWizard.this.matchedServerTargetCombo.getVisibleItemCount() != 0) {
                SeamProjectWizard.this.matchedServerTargetCombo.select(0);
            }
            this.setWebModuleVersion();
        }

        protected String[] getValidationPropertyNames() {
            String[] superProperties = super.getValidationPropertyNames();
            List<String> list = Arrays.asList(superProperties);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(list);
            arrayList.add("seam.project.deployment.runtime");
            arrayList.add("seam.project.deployment.target");
            arrayList.add("project.name");
            return arrayList.toArray(new String[0]);
        }

        public boolean launchNewServerWizard(Shell shell, IDataModel model) {
            return this.launchNewServerWizard(shell, model, null);
        }

        public boolean isAs7orHigherSelected() {
            IRuntime targetRuntime;
            String runtimeName = SeamProjectWizard.this.serverRuntimeTargetCombo.getText();
            if (RuntimeManager.isRuntimeDefined((String)runtimeName) && (targetRuntime = RuntimeManager.getRuntime((String)runtimeName)) instanceof BridgedRuntime) {
                List components = ((BridgedRuntime)targetRuntime).getRuntimeComponents();
                for (IRuntimeComponent component : components) {
                    String typeId = component.getProperty("type-id");
                    if (typeId == null) continue;
                    if (typeId.startsWith("org.jboss.ide.eclipse.as.runtime.7") || typeId.startsWith("org.jboss.ide.eclipse.as.runtime.wildfly")) {
                        return true;
                    }
                    if (!typeId.startsWith("org.jboss.ide.eclipse.as.runtime.eap.") || typeId.length() <= "org.jboss.ide.eclipse.as.runtime.eap.".length()) continue;
                    String v = typeId.substring("org.jboss.ide.eclipse.as.runtime.eap.".length());
                    int number = 0;
                    try {
                        number = Integer.parseInt(v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        int n = number = v.compareTo("6") >= 0 ? 6 : 0;
                    }
                    if (number < 6) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean setWebModuleVersion() {
            this.lastWeb25Template = SeamProjectWizard.this.seamConfigTemplate != SeamProjectWizard.templateJstSeam23 && SeamProjectWizard.this.seamConfigTemplate != null && !SeamProjectWizard.this.seamConfigTemplate.isEmpty() ? SeamProjectWizard.this.seamConfigTemplate : SeamProjectWizard.templateJstSeam22;
            this.lastWeb25ComboIndex = this.primaryVersionCombo.getSelectionIndex();
            String[] items = this.primaryVersionCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if ("2.5".equals(items[0])) {
                    this.lastWeb25ComboIndex = i;
                    break;
                }
                ++i;
            }
            if (this.isAs7orHigherSelected() && this.primaryVersionCombo.getItemCount() > 0) {
                this.setTemplate(SeamProjectWizard.templateJstSeam23, this.primaryVersionCombo.getItemCount() - 1);
                return true;
            }
            if (this.lastWeb25Template != null && !this.lastWeb25Template.equals(SeamProjectWizard.this.seamConfigTemplate)) {
                this.setTemplate(this.lastWeb25Template, this.lastWeb25ComboIndex);
                return true;
            }
            return false;
        }

        private void setTemplate(String newTemplate, int primaryVersionComboIndex) {
            this.primaryVersionCombo.select(primaryVersionComboIndex);
            SeamProjectWizard.this.seamConfigTemplate = newTemplate;
            SeamProjectWizard.this.template = ProjectFacetsManager.getTemplate((String)SeamProjectWizard.this.seamConfigTemplate);
            SeamProjectWizard.this.getFacetedProjectWorkingCopy().setFixedProjectFacets(SeamProjectWizard.this.template.getFixedProjectFacets());
            IPreset preset = SeamProjectWizard.this.template.getInitialPreset();
            SeamProjectWizard.this.getFacetedProjectWorkingCopy().setSelectedPreset(preset.getId());
        }

        public IProjectFacetVersion getPrimaryFacetVersion() {
            return super.getPrimaryFacetVersion();
        }

        public boolean isPageComplete() {
            boolean pageComplete = super.isPageComplete();
            IProjectFacet pFacet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
            IFacetedProjectWorkingCopy fProject = SeamProjectWizard.this.getFacetedProjectWorkingCopy();
            if (fProject != null) {
                IProjectFacetVersion seamFacet = fProject.getProjectFacetVersion(pFacet);
                if (seamFacet == null) {
                    if (pageComplete) {
                        this.setErrorMessage(SeamCoreMessages.SEAM_PROJECT_WIZARD_PAGE1_SEAM_FACET_MUST_BE_SPECIFIED);
                        return false;
                    }
                } else if (pageComplete) {
                    this.setErrorMessage(null);
                } else if (SeamCoreMessages.SEAM_PROJECT_WIZARD_PAGE1_SEAM_FACET_MUST_BE_SPECIFIED.equals(this.getErrorMessage())) {
                    this.setErrorMessage(null);
                }
            }
            return pageComplete;
        }

        public boolean launchNewServerWizard(Shell shell, final IDataModel model, String serverTypeID) {
            DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("seam.project.deployment.target");
            IRuntime rt = (IRuntime)model.getProperty("seam.project.deployment.runtime");
            IServerLifecycleListener serverListener = new IServerLifecycleListener(){

                public void serverAdded(IServer server) {
                    DataModelPropertyDescriptor[] descriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                    int i = 0;
                    while (i < descriptors.length) {
                        if (server.getRuntime().getName().equals(descriptors[i].getPropertyDescription())) {
                            model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", descriptors[i].getPropertyValue());
                            model.setProperty("seam.project.deployment.runtime", descriptors[i].getPropertyValue());
                        }
                        ++i;
                    }
                    model.setProperty("seam.project.deployment.target", (Object)server);
                }

                public void serverChanged(IServer server) {
                }

                public void serverRemoved(IServer server) {
                }
            };
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)serverListener);
            boolean isOK = false;
            try {
                isOK = ServerUIUtil.showNewServerWizard((Shell)shell, (String)serverTypeID, null, rt == null ? null : null);
            }
            finally {
                ServerCore.removeServerLifecycleListener((IServerLifecycleListener)serverListener);
            }
            if (isOK && model != null) {
                DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("seam.project.deployment.target");
                Object[] preAddition = new Object[preAdditionDescriptors.length];
                int i = 0;
                while (i < preAddition.length) {
                    preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                    ++i;
                }
                Object[] postAddition = new Object[postAdditionDescriptors.length];
                int i2 = 0;
                while (i2 < postAddition.length) {
                    postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                    ++i2;
                }
                Object newAddition = null;
                if (preAddition != null && postAddition != null && preAddition.length < postAddition.length) {
                    int i3 = 0;
                    while (i3 < postAddition.length) {
                        boolean found = false;
                        Object object = postAddition[i3];
                        int j = 0;
                        while (j < preAddition.length) {
                            if (preAddition[j] == object) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            newAddition = object;
                        }
                        ++i3;
                    }
                }
                if (preAddition == null && postAddition != null && postAddition.length == 1) {
                    newAddition = postAddition[0];
                }
                model.notifyPropertyChange("seam.project.deployment.target", 4);
                this.isPageComplete();
                if (newAddition != null) {
                    model.setProperty("seam.project.deployment.target", newAddition);
                } else {
                    return false;
                }
            }
            return isOK;
        }

        public boolean internalLaunchNewServerWizard(Shell shell, IDataModel model) {
            return this.launchNewServerWizard(shell, model, this.getModuleTypeID());
        }

        public void restoreDefaultSettings() {
            super.restoreDefaultSettings();
            String lastServerName = SeamProjectPreferences.getStringPreference((String)"org.jboss.tools.seam.core.project.facet.last.server.name");
            if (lastServerName != null && lastServerName.length() > 0) {
                SeamFacetProjectCreationDataModelProvider.setServerName((IDataModel)this.model, (String)lastServerName);
            }
        }

        public void storeDefaultSettings() {
            super.storeDefaultSettings();
            Preferences preferences = SeamCorePlugin.getDefault().getPluginPreferences();
            String serverName = SeamFacetProjectCreationDataModelProvider.getServerName((IDataModel)this.model);
            if (serverName != null && serverName.length() > 0) {
                preferences.setValue("org.jboss.tools.seam.core.project.facet.last.server.name", serverName);
            }
            if (SeamProjectWizard.this.seamConfigTemplate != null) {
                preferences.setValue("org.jboss.tools.seam.core.project.facet.config.template", SeamProjectWizard.this.seamConfigTemplate);
            }
        }
    }
}

