/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.ui.NewConnectionProfileWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.common.ui.widget.editor.ButtonFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ComboFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.widget.editor.SeamRuntimeListFieldEditor;
import org.jboss.tools.seam.ui.wizard.SelectJavaPackageAction;
import org.jboss.tools.seam.ui.wizard.SelectSeamProjectAction;
import org.jboss.tools.seam.ui.wizard.ShowProjectSettingsAction;

public class SeamWizardFactory {
    public static IFieldEditor createSeamProjectSelectionFieldEditor(String name, String label, String defaultSelection, boolean allowAllProjects, boolean editSettings) {
        if (!editSettings) {
            return IFieldEditorFactory.INSTANCE.createButtonFieldEditor(name, label, defaultSelection, (ButtonFieldEditor.ButtonPressedAction)new SelectSeamProjectAction(allowAllProjects), SeamValidatorFactory.NO_ERRORS_VALIDATOR);
        }
        SelectSeamProjectAction buttonAction = new SelectSeamProjectAction(allowAllProjects);
        ShowProjectSettingsAction settingsAction = new ShowProjectSettingsAction();
        ButtonFieldEditor.ButtonPressedAction[] buttonPressedActionArray = new ButtonFieldEditor.ButtonPressedAction[]{buttonAction, settingsAction};
        IFieldEditor editor = IFieldEditorFactory.INSTANCE.createButtonAndLinkFieldEditor(name, label, defaultSelection, (ButtonFieldEditor.ButtonPressedAction)buttonAction, (ButtonFieldEditor.ButtonPressedAction)settingsAction, SeamValidatorFactory.NO_ERRORS_VALIDATOR);
        settingsAction.setEnabled(false);
        settingsAction.setEditor(editor);
        return editor;
    }

    public static IFieldEditor createSeamProjectSelectionFieldEditor(String defaultSelection) {
        return SeamWizardFactory.createSeamProjectSelectionFieldEditor("seam.project.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_SEAM_PROJECT, defaultSelection, false, true);
    }

    public static IFieldEditor createSeamLocalInterfaceNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("interface.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_LOCAL_INTERFACE_NAME, "");
    }

    public static IFieldEditor createSeamBeanNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("bean.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_BEAN_NAME, "");
    }

    public static IFieldEditor createSeamMethodNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("method.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_METHOD_NAME, "");
    }

    public static IFieldEditor createSeamPageNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("page.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_PAGE_NAME, "");
    }

    public static IFieldEditor createSeamMasterPageNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("masterPage.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_MASTER_PAGE_NAME, "");
    }

    public static final IFieldEditor[] createBaseFormFieldEditors(String defaultSelection) {
        return new IFieldEditor[]{SeamWizardFactory.createSeamProjectSelectionFieldEditor(defaultSelection), SeamWizardFactory.createSeamComponentNameFieldEditor(), SeamWizardFactory.createSeamLocalInterfaceNameFieldEditor(), SeamWizardFactory.createSeamBeanNameFieldEditor(), SeamWizardFactory.createSeamMethodNameFieldEditor(), SeamWizardFactory.createSeamPageNameFieldEditor()};
    }

    public static IFieldEditor createSeamJavaPackageSelectionFieldEditor(String defaultSelection) {
        return IFieldEditorFactory.INSTANCE.createButtonFieldEditor("seam.package.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_PACKAGE_NAME, defaultSelection, (ButtonFieldEditor.ButtonPressedAction)new SelectJavaPackageAction(), SeamValidatorFactory.NO_ERRORS_VALIDATOR);
    }

    public static IFieldEditor createSeamRuntimeSelectionFieldEditor(SeamVersion[] seamVersions, String defaultValue, NewSeamRuntimeAction action) {
        return SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(seamVersions, defaultValue, action, false);
    }

    public static IFieldEditor createSeamRuntimeSelectionFieldEditor(SeamVersion[] seamVersions, String defaultValue, NewSeamRuntimeAction action, boolean canBeEmpty) {
        if (seamVersions.length == 0) {
            seamVersions = SeamVersion.ALL_VERSIONS;
        }
        List<String> names = SeamWizardFactory.getRuntimeNames(seamVersions);
        if (defaultValue != null && defaultValue.trim().length() > 0 && !names.contains(defaultValue)) {
            names.add(0, defaultValue);
        }
        if (canBeEmpty) {
            names.add(0, "");
        }
        IFieldEditor jBossSeamRuntimeEditor = IFieldEditorFactory.INSTANCE.createComboWithButton("seam.runtime.name", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_SEAM_RUNTIME, names, (Object)defaultValue, true, (ButtonFieldEditor.ButtonPressedAction)action, null);
        return jBossSeamRuntimeEditor;
    }

    public static IFieldEditor createConnectionProfileSelectionFieldEditor(Object defaultValue, IValidator validator, final boolean canBeEmpty) {
        EditConnectionProfileAction editAction = new EditConnectionProfileAction(validator);
        NewConnectionProfileAction newAction = new NewConnectionProfileAction(validator);
        List<String> profiles = SeamWizardFactory.getConnectionProfileNameList();
        if (canBeEmpty) {
            profiles.add(0, "");
        }
        IFieldEditor connProfileSelEditor = IFieldEditorFactory.INSTANCE.createComboWithTwoButtons("seam.project.connection.profile", SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_CONNECTION_PROFILE, profiles, defaultValue, false, (ButtonFieldEditor.ButtonPressedAction)editAction, (ButtonFieldEditor.ButtonPressedAction)newAction, SeamValidatorFactory.NO_ERRORS_VALIDATOR);
        editAction.setEditor(connProfileSelEditor);
        newAction.setEditor(connProfileSelEditor);
        final ButtonFieldEditor editButton = (ButtonFieldEditor)((CompositeEditor)connProfileSelEditor).getEditors().get(2);
        editButton.setEnabled(!"".equals(defaultValue));
        if (canBeEmpty) {
            connProfileSelEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean ediatble = !"".equals(evt.getNewValue());
                    editButton.setEnabled(ediatble);
                }
            });
        }
        final ComboFieldEditor comboEditor = (ComboFieldEditor)((CompositeEditor)connProfileSelEditor).getEditors().get(1);
        final IProfileListener profileListener = new IProfileListener(){

            private void update() {
                final List profiles = SeamWizardFactory.getConnectionProfileNameList();
                if (canBeEmpty) {
                    profiles.add(0, "");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        comboEditor.setTags(profiles.toArray(new String[0]));
                    }
                });
            }

            public void profileAdded(IConnectionProfile profile) {
                this.update();
            }

            public void profileChanged(IConnectionProfile profile) {
                this.update();
            }

            public void profileDeleted(IConnectionProfile profile) {
                this.update();
            }
        };
        ProfileManager.getInstance().addProfileListener(profileListener);
        comboEditor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProfileManager.getInstance().removeProfileListener(profileListener);
            }
        });
        return connProfileSelEditor;
    }

    public static IFieldEditor createConnectionProfileSelectionFieldEditor(Object defaultValue, IValidator validator) {
        return SeamWizardFactory.createConnectionProfileSelectionFieldEditor(defaultValue, validator, false);
    }

    private static List<String> getConnectionProfileNameList() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        ArrayList<String> names = new ArrayList<String>();
        IConnectionProfile[] iConnectionProfileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
            names.add(connectionProfile.getName());
            ++n2;
        }
        return names;
    }

    public static IFieldEditor createSeamRuntimeSelectionFieldEditor(SeamVersion[] seamVersions, String defaultValue) {
        return SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(seamVersions, defaultValue, false);
    }

    public static IFieldEditor createSeamRuntimeSelectionFieldEditor(SeamVersion[] seamVersions, String defaultValue, boolean canBeEmpty) {
        DefaultNewSeamRuntimeAction action = new DefaultNewSeamRuntimeAction(seamVersions);
        IFieldEditor jBossSeamRuntimeEditor = SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(seamVersions, defaultValue, action, canBeEmpty);
        action.setRuntimeSelectionEditor(jBossSeamRuntimeEditor);
        return jBossSeamRuntimeEditor;
    }

    public static IFieldEditor createSeamRuntimeSelectionFieldEditor(String defaultValue) {
        return SeamWizardFactory.createSeamRuntimeSelectionFieldEditor(new SeamVersion[0], defaultValue, false);
    }

    private static List<String> getRuntimeNames(SeamVersion[] seamVersions) {
        ArrayList<String> rtStrings = new ArrayList<String>();
        int i = 0;
        while (i < seamVersions.length) {
            SeamRuntime[] rts;
            SeamRuntime[] seamRuntimeArray = rts = SeamRuntimeManager.getInstance().getRuntimes(seamVersions[i]);
            int n = rts.length;
            int n2 = 0;
            while (n2 < n) {
                SeamRuntime seamRuntime = seamRuntimeArray[n2];
                rtStrings.add(seamRuntime.getName());
                ++n2;
            }
            ++i;
        }
        return rtStrings;
    }

    public static IFieldEditor createSeamComponentNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("component.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_SEAM_COMPONENT_NAME, "");
    }

    public static IFieldEditor createSeamEntityClasNameFieldEditor() {
        return IFieldEditorFactory.INSTANCE.createTextEditor("entity.name", SeamCoreMessages.SEAM_WIZARD_FACTORY_SEAM_ENTITY_CLASS_NAME, "");
    }

    public static IFieldEditor createHibernateConsoleConfigurationSelectionFieldEditor(String defaultSelection) {
        HibernateConsolePlugin.getDefault();
        ConsoleConfiguration[] configs = KnownConfigurations.getInstance().getConfigurations();
        ArrayList<String> configurationNames = new ArrayList<String>();
        int i = 0;
        while (i < configs.length) {
            configurationNames.add(configs[i].getName());
            ++i;
        }
        if (defaultSelection == null) {
            defaultSelection = !configurationNames.isEmpty() ? (String)configurationNames.get(0) : "";
        }
        ITaggedFieldEditor editor = IFieldEditorFactory.INSTANCE.createComboEditor("hibernate.configuratrion.name", SeamCoreMessages.GENERATE_SEAM_ENTITIES_WIZARD_HIBERNATE_CONFIGURATION_LABEL, configurationNames, (Object)defaultSelection);
        return editor;
    }

    public static IFieldEditor createViewFolderFieldEditor(String defaultSelection) {
        IFieldEditor viewDirEditor = IFieldEditorFactory.INSTANCE.createBrowseWorkspaceFolderEditor("seam.project.web.root.folder", SeamCoreMessages.VIEW_FOLDER_FILED_EDITOR, defaultSelection);
        return viewDirEditor;
    }

    private static class ConnectionProfileChangeListener
    implements IProfileListener {
        private IFieldEditor connProfileSelEditor;
        private IValidator validator;

        public ConnectionProfileChangeListener(IValidator validator, IFieldEditor connProfileSelEditor) {
            this.validator = validator;
            this.connProfileSelEditor = connProfileSelEditor;
        }

        public void profileAdded(final IConnectionProfile profile) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionProfileChangeListener.this.connProfileSelEditor.setValue((Object)profile.getName());
                    ((ITaggedFieldEditor)((CompositeEditor)ConnectionProfileChangeListener.this.connProfileSelEditor).getEditors().get(1)).setTags(SeamWizardFactory.getConnectionProfileNameList().toArray(new String[0]));
                }
            });
            this.validator.validate((Object)profile.getName(), null);
        }

        public void profileChanged(IConnectionProfile profile) {
            this.profileAdded(profile);
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }

    private static class DefaultNewSeamRuntimeAction
    extends NewSeamRuntimeAction {
        private SeamVersion[] seamVersions;
        private IFieldEditor runtimeSelectionEditor;

        public DefaultNewSeamRuntimeAction() {
        }

        public DefaultNewSeamRuntimeAction(SeamVersion[] seamVersions) {
            this();
            this.seamVersions = seamVersions;
        }

        void setRuntimeSelectionEditor(IFieldEditor runtimeSelectionEditor) {
            this.runtimeSelectionEditor = runtimeSelectionEditor;
        }

        @Override
        protected SeamVersion[] getSeamVersions() {
            return this.seamVersions;
        }

        @Override
        protected IFieldEditor getRuntimeSelectionEditor() {
            return this.runtimeSelectionEditor;
        }
    }

    private static class EditConnectionProfileAction
    extends ButtonFieldEditor.ButtonPressedAction {
        private IValidator validator;
        private IFieldEditor connProfileSelEditor;

        public EditConnectionProfileAction(IValidator validator) {
            super(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_EDIT);
            this.validator = validator;
        }

        public void run() {
            IConnectionProfile selectedProfile = ProfileManager.getInstance().getProfileByName(this.getFieldEditor().getValue().toString());
            String oldName = this.getFieldEditor().getValue().toString();
            if (selectedProfile == null) {
                return;
            }
            PropertyDialog.createDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)"org.eclipse.datatools.connectivity.db.generic.profileProperties", (Object)selectedProfile).open();
            if (!oldName.equals(selectedProfile.getName())) {
                this.getFieldEditor().setValue((Object)selectedProfile.getName());
                ((ITaggedFieldEditor)((CompositeEditor)this.connProfileSelEditor).getEditors().get(1)).setTags(SeamWizardFactory.getConnectionProfileNameList().toArray(new String[0]));
                oldName = selectedProfile.getName();
            }
            this.validator.validate((Object)selectedProfile.getName(), null);
        }

        public void setEditor(IFieldEditor connProfileSelEditor) {
            this.connProfileSelEditor = connProfileSelEditor;
        }
    }

    private static class NewConnectionProfileAction
    extends ButtonFieldEditor.ButtonPressedAction {
        private IValidator validator;
        private IFieldEditor connProfileSelEditor;

        public NewConnectionProfileAction(IValidator validator) {
            super(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_NEW);
            this.validator = validator;
        }

        public void run() {
            ConnectionProfileChangeListener listener = new ConnectionProfileChangeListener(this.validator, this.connProfileSelEditor);
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            NewCPWizardCategoryFilter filter = new NewCPWizardCategoryFilter("org.eclipse.datatools.connectivity.db.category");
            NewCPWizard wizard = new NewCPWizard((ViewerFilter)filter, null);
            new NewConnectionProfileWizard(){

                public boolean performFinish() {
                    try {
                        ProfileManager.getInstance().createProfile(this.getProfileName() == null ? "" : this.getProfileName(), this.getProfileDescription() == null ? "" : this.getProfileDescription(), this.mProviderID, this.getProfileProperties(), this.mProfilePage.getRepository() == null ? "" : this.mProfilePage.getRepository().getName(), false);
                    }
                    catch (ConnectionProfileException e) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                    return true;
                }
            };
            WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            wizardDialog.open();
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        }

        public void setEditor(IFieldEditor connProfileSelEditor) {
            this.connProfileSelEditor = connProfileSelEditor;
        }
    }

    public static abstract class NewSeamRuntimeAction
    extends ButtonFieldEditor.ButtonPressedAction {
        public NewSeamRuntimeAction() {
            super(SeamCoreMessages.SEAM_INSTALL_WIZARD_PAGE_ADD);
        }

        protected abstract SeamVersion[] getSeamVersions();

        protected abstract IFieldEditor getRuntimeSelectionEditor();

        public void run() {
            ArrayList<SeamRuntime> added = new ArrayList<SeamRuntime>();
            ArrayList<SeamVersion> versions = new ArrayList<SeamVersion>(1);
            SeamVersion[] sv = this.getSeamVersions();
            int i = 0;
            while (i < sv.length) {
                versions.add(sv[i]);
                ++i;
            }
            if (versions.isEmpty()) {
                SeamVersion[] allVersions = SeamVersion.ALL_VERSIONS;
                int i2 = 0;
                while (i2 < allVersions.length) {
                    versions.add(allVersions[i2]);
                    ++i2;
                }
            }
            SeamRuntimeListFieldEditor.SeamRuntimeNewWizard wiz = new SeamRuntimeListFieldEditor.SeamRuntimeNewWizard(new ArrayList<SeamRuntime>(Arrays.asList(SeamRuntimeManager.getInstance().getRuntimes())), added, versions);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            if (!added.isEmpty()) {
                SeamRuntimeManager.getInstance().addRuntime((SeamRuntime)added.get(0));
                List runtimes = SeamWizardFactory.getRuntimeNames(sv);
                this.getFieldEditor().setValue((Object)((SeamRuntime)added.get(0)).getName());
                ((ITaggedFieldEditor)((CompositeEditor)this.getRuntimeSelectionEditor()).getEditors().get(1)).setTags(runtimes.toArray(new String[0]));
            }
        }
    }
}

