/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.text.ext.hyperlink.ITestableCDIHyperlink;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.model.ui.texteditors.XMLTextEditorStandAlone;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkDetector;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.AxisUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.ui.editors.WebCompoundEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditorPart;
import org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.ELHyperlinkDetector;

public class CDIHyperlinkTestUtil
extends TestCase {
    public static void checkRegionsInJar(IProject project, String fullyQualifiedName, List<TestRegion> regionList, AbstractHyperlinkDetector hlDetector) throws Exception {
        IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
        CDIHyperlinkTestUtil.assertNotNull((String)"Java Project is null", (Object)javaProject);
        IType type = javaProject.findType(fullyQualifiedName);
        CDIHyperlinkTestUtil.assertNotNull((String)"Type is not found", (Object)type);
        CDIHyperlinkTestUtil.assertTrue((String)"Type must be exist", (boolean)type.exists());
        IEditorInput editorInput = EditorUtility.getEditorInput((Object)type);
        IEditorPart editorPart = EditorUtility.openInEditor((Object)type);
        CDIHyperlinkTestUtil.checkRegions(fullyQualifiedName, editorInput, editorPart, regionList, (IHyperlinkDetector)hlDetector);
    }

    protected static ISourceViewer getViewer(IEditorPart editor) {
        if (editor instanceof JavaEditor) {
            return ((JavaEditor)editor).getViewer();
        }
        Assert.fail((String)"editor must be instanceof JavaEditor");
        return null;
    }

    public static void checkRegions(IProject project, String fileName, List<TestRegion> regionList, IHyperlinkDetector hlDetector) throws Exception {
        IFile file = project.getFile(fileName);
        CDIHyperlinkTestUtil.assertNotNull((String)("The file \"" + fileName + "\" is not found"), (Object)file);
        CDIHyperlinkTestUtil.assertTrue((String)("The file \"" + fileName + "\" is not found"), (boolean)file.isAccessible());
        FileEditorInput editorInput = new FileEditorInput(file);
        IEditorPart editorPart = CDIHyperlinkTestUtil.openFileInEditor(file);
        CDIHyperlinkTestUtil.checkRegions(fileName, (IEditorInput)editorInput, editorPart, regionList, hlDetector);
    }

    public static void checkRegionsForAsYouType(IProject project, String fileName, String newContent, List<TestRegion> regionList, IHyperlinkDetector hlDetector) throws Exception {
        IFile file = project.getFile(fileName);
        IFile nFile = project.getFile(newContent);
        CDIHyperlinkTestUtil.assertNotNull((String)("The file \"" + fileName + "\" is not found"), (Object)file);
        CDIHyperlinkTestUtil.assertTrue((String)("The file \"" + fileName + "\" is not found"), (boolean)file.isAccessible());
        CDIHyperlinkTestUtil.assertNotNull((String)("The file \"" + newContent + "\" is not found"), (Object)nFile);
        CDIHyperlinkTestUtil.assertTrue((String)("The file \"" + newContent + "\" is not found"), (boolean)nFile.isAccessible());
        FileEditorInput editorInput = new FileEditorInput(file);
        IEditorPart editorPart = CDIHyperlinkTestUtil.openFileInEditor(file);
        try {
            ISourceViewer viewer = CDIHyperlinkTestUtil.getViewer(editorPart);
            IDocument document = viewer.getDocument();
            String text = FileUtil.getContentFromEditorOrFile((IFile)nFile);
            document.set(text);
            CDIHyperlinkTestUtil.checkRegions(fileName, (IEditorInput)editorInput, editorPart, regionList, hlDetector);
        }
        finally {
            if (editorPart.isDirty()) {
                editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private static void checkRegions(String fileName, IEditorInput editorInput, IEditorPart editorPart, List<TestRegion> regionList, IHyperlinkDetector hlDetector) throws Exception {
        IEditorPart[] parts;
        ISourceViewer viewer = null;
        if (editorPart instanceof JavaEditor) {
            viewer = ((JavaEditor)editorPart).getViewer();
            if (hlDetector instanceof AbstractHyperlinkDetector) {
                ((AbstractHyperlinkDetector)hlDetector).setContext((IAdaptable)new TestContext((ITextEditor)editorPart));
            }
        } else if (editorPart instanceof EditorPartWrapper) {
            if (((EditorPartWrapper)editorPart).getEditor() instanceof WebCompoundEditor) {
                WebCompoundEditor wce = (WebCompoundEditor)((EditorPartWrapper)editorPart).getEditor();
                viewer = wce.getSourceEditor().getTextViewer();
                if (hlDetector instanceof AbstractHyperlinkDetector) {
                    ((AbstractHyperlinkDetector)hlDetector).setContext((IAdaptable)new TestContext((ITextEditor)wce.getSourceEditor()));
                }
            } else if (((EditorPartWrapper)editorPart).getEditor() instanceof XMLTextEditorStandAlone) {
                XMLTextEditorStandAlone xtesa = (XMLTextEditorStandAlone)((EditorPartWrapper)editorPart).getEditor();
                viewer = xtesa.getTextViewer();
                if (hlDetector instanceof AbstractHyperlinkDetector) {
                    ((AbstractHyperlinkDetector)hlDetector).setContext((IAdaptable)new TestContext((ITextEditor)xtesa));
                }
            } else {
                CDIHyperlinkTestUtil.fail((String)("unsupported editor type - " + ((EditorPartWrapper)editorPart).getEditor().getClass()));
            }
        } else if (editorPart instanceof XMLMultiPageEditorPart) {
            parts = ((XMLMultiPageEditorPart)editorPart).findEditors(editorInput);
            if (parts.length > 0) {
                viewer = ((StructuredTextEditor)parts[0]).getTextViewer();
            }
        } else if (editorPart instanceof JSPMultiPageEditor) {
            parts = ((JSPMultiPageEditorPart)editorPart).findEditors(editorInput);
            if (parts.length > 0) {
                viewer = ((StructuredTextEditor)parts[0]).getTextViewer();
            }
        } else if (editorPart instanceof ObjectMultiPageEditor) {
            viewer = ((ObjectMultiPageEditor)editorPart).getSourceEditor().getTextViewer();
        } else if (editorPart instanceof StructuredTextEditor) {
            viewer = ((StructuredTextEditor)editorPart).getTextViewer();
        } else {
            CDIHyperlinkTestUtil.fail((String)("unsupported editor type - " + editorPart.getClass()));
        }
        IDocument document = viewer.getDocument();
        CDIHyperlinkTestUtil.assertNotNull((String)("The document for the file \"" + fileName + "\" is not loaded"), (Object)document);
        if (regionList.get((int)0).region == null) {
            CDIHyperlinkTestUtil.loadRegions(regionList, document);
        }
        int expected = 0;
        for (TestRegion testRegion : regionList) {
            expected += testRegion.region.getLength() + 1;
        }
        int counter = 0;
        int i = 0;
        while (i < document.getLength()) {
            boolean recognized;
            int lineNumber = document.getLineOfOffset(i);
            int position = i - document.getLineOffset(lineNumber) + 1;
            ++lineNumber;
            TestData testData = new TestData(document, i);
            IHyperlink[] links = hlDetector.detectHyperlinks((ITextViewer)viewer, (IRegion)testData.getHyperlinkRegion(), true);
            boolean bl = recognized = links != null;
            if (recognized) {
                ++counter;
                TestRegion testRegion = CDIHyperlinkTestUtil.findOffsetInRegions(i, regionList);
                String information = CDIHyperlinkTestUtil.findRegionInformation(document, i, regionList);
                if (testRegion == null) {
                    CDIHyperlinkTestUtil.fail((String)("Wrong detection for offset - " + i + " (line - " + lineNumber + " position - " + position + ") " + information));
                } else {
                    CDIHyperlinkTestUtil.checkTestRegion(links, testRegion, information);
                }
            } else {
                for (TestRegion testRegion : regionList) {
                    if (i < testRegion.region.getOffset() || i > testRegion.region.getOffset() + testRegion.region.getLength()) continue;
                    CDIHyperlinkTestUtil.fail((String)("Wrong detection for region - " + CDIHyperlinkTestUtil.getRegionInformation(document, testRegion) + " offset - " + i + " (line - " + lineNumber + " position - " + position + ")"));
                }
            }
            ++i;
        }
        CDIHyperlinkTestUtil.assertEquals((String)"Wrong recognized region count: ", (int)expected, (int)counter);
    }

    public static void checkTestRegion(IHyperlink[] links, TestRegion testRegion, String information) {
        IHyperlink[] iHyperlinkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink link = iHyperlinkArray[n2];
            TestHyperlink testLink = CDIHyperlinkTestUtil.findTestHyperlink(testRegion.hyperlinks, link);
            CDIHyperlinkTestUtil.assertNotNull((String)("Unexpected hyperlink - " + link.getHyperlinkText() + " " + information), (Object)testLink);
            CDIHyperlinkTestUtil.assertEquals((String)("Unexpected hyperlink type " + information), testLink.hyperlink, link.getClass());
            CDIHyperlinkTestUtil.assertTrue((String)("Validation fails for hyperlink - " + link.getHyperlinkText() + " " + information), (boolean)testLink.validateHyperlink(link));
            if (testLink.fileName != null) {
                CDIHyperlinkTestUtil.assertTrue((String)("HyperLink must be inherited from AbstractHyperlink " + information), (boolean)(link instanceof AbstractHyperlink));
                IFile f = ((AbstractHyperlink)link).getReadyToOpenFile();
                CDIHyperlinkTestUtil.assertNotNull((String)("HyperLink must return not null file " + information), (Object)f);
                CDIHyperlinkTestUtil.assertEquals((String)testLink.fileName, (String)f.getName());
            }
            ++n2;
        }
        for (TestHyperlink testLink : testRegion.hyperlinks) {
            IHyperlink link = CDIHyperlinkTestUtil.findHyperlink(links, testLink);
            CDIHyperlinkTestUtil.assertNotNull((String)("Hyperlink - " + testLink.name + " not found " + information), (Object)link);
        }
    }

    private static TestHyperlink findTestHyperlink(List<TestHyperlink> testHyperlinks, IHyperlink link) {
        for (TestHyperlink testLink : testHyperlinks) {
            if (!testLink.name.equals(link.getHyperlinkText())) continue;
            return testLink;
        }
        return null;
    }

    private static IHyperlink findHyperlink(IHyperlink[] links, TestHyperlink testLink) {
        IHyperlink[] iHyperlinkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink link = iHyperlinkArray[n2];
            if (testLink.name.equals(link.getHyperlinkText())) {
                return link;
            }
            ++n2;
        }
        return null;
    }

    private static void loadRegions(List<TestRegion> regionList, IDocument document) throws BadLocationException {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        IRegion region = adapter.find(0, "{", true, true, false, false);
        if (region == null) {
            region = new Region(0, 0);
        }
        for (TestRegion testRegion : regionList) {
            IRegion newRegion = adapter.find(region.getOffset() + region.getLength(), testRegion.regionText, true, true, false, false);
            if (newRegion != null) {
                testRegion.region = newRegion;
                region = newRegion;
                continue;
            }
            CDIHyperlinkTestUtil.fail((String)("Can not find string - " + testRegion.regionText));
        }
        int i = regionList.size() - 1;
        while (i >= 0) {
            TestRegion r = regionList.get(i);
            if (r.hyperlinks.size() == 0) {
                regionList.remove(r);
            }
            --i;
        }
    }

    public static void checkHyperLinkInXml(IProject project, String fileName, int offset, String hyperlinkClassName) throws Exception {
        CDIHyperlinkTestUtil.checkHyperLinkInXml(fileName, project, offset, hyperlinkClassName);
    }

    public static IHyperlink checkHyperLinkInXml(String fileName, IProject project, int offset, String hyperlinkClassName) throws Exception {
        IHyperlink[] links = CDIHyperlinkTestUtil.detectHyperlinks(fileName, project, offset);
        if (links != null) {
            IHyperlink[] iHyperlinkArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlink hyperlink = iHyperlinkArray[n2];
                if (hyperlink.getClass().getName().equals(hyperlinkClassName)) {
                    return hyperlink;
                }
                ++n2;
            }
        }
        CDIHyperlinkTestUtil.fail((String)"Can't find HyperLink");
        return null;
    }

    public static IHyperlink[] detectHyperlinks(String fileName, IProject project, int offset) {
        Region region = new Region(offset, 0);
        IFile file = project.getFile(fileName);
        CDIHyperlinkTestUtil.assertNotNull((String)("The file \"" + fileName + "\" is not found"), (Object)file);
        CDIHyperlinkTestUtil.assertTrue((String)("The file \"" + fileName + "\" is not found"), (boolean)file.isAccessible());
        FileEditorInput editorInput = new FileEditorInput(file);
        IEditorPart part = CDIHyperlinkTestUtil.openFileInEditor(file);
        if (part instanceof EditorPartWrapper) {
            part = ((EditorPartWrapper)part).getEditor();
        }
        StructuredTextViewer viewer = null;
        if (part instanceof XMLMultiPageEditorPart) {
            IEditorPart[] parts = ((XMLMultiPageEditorPart)part).findEditors((IEditorInput)editorInput);
            if (parts.length > 0) {
                viewer = ((StructuredTextEditor)parts[0]).getTextViewer();
            }
        } else if (part instanceof JSPMultiPageEditor) {
            IEditorPart[] parts = ((JSPMultiPageEditorPart)part).findEditors((IEditorInput)editorInput);
            if (parts.length > 0) {
                viewer = ((StructuredTextEditor)parts[0]).getTextViewer();
            }
        } else if (part instanceof ObjectMultiPageEditor) {
            viewer = ((ObjectMultiPageEditor)part).getSourceEditor().getTextViewer();
        } else if (part instanceof StructuredTextEditor) {
            viewer = ((StructuredTextEditor)part).getTextViewer();
        }
        return HyperlinkDetector.getInstance().detectHyperlinks((ITextViewer)viewer, (IRegion)region, true);
    }

    public static IHyperlink[] detectELHyperlinks(String fileName, IProject project, int offset) {
        Region region = new Region(offset, 0);
        IFile file = project.getFile(fileName);
        CDIHyperlinkTestUtil.assertNotNull((String)("The file \"" + fileName + "\" is not found"), (Object)file);
        CDIHyperlinkTestUtil.assertTrue((String)("The file \"" + fileName + "\" is not found"), (boolean)file.isAccessible());
        FileEditorInput editorInput = new FileEditorInput(file);
        IEditorPart part = CDIHyperlinkTestUtil.openFileInEditor(file);
        if (part instanceof EditorPartWrapper) {
            part = ((EditorPartWrapper)part).getEditor();
        }
        StructuredTextViewer viewer = null;
        if (part instanceof XMLMultiPageEditorPart) {
            IEditorPart[] parts = ((XMLMultiPageEditorPart)part).findEditors((IEditorInput)editorInput);
            if (parts.length > 0) {
                viewer = ((StructuredTextEditor)parts[0]).getTextViewer();
            }
        } else if (part instanceof JSPMultiPageEditor) {
            IEditorPart[] parts = ((JSPMultiPageEditorPart)part).findEditors((IEditorInput)editorInput);
            if (parts.length > 0) {
                viewer = ((StructuredTextEditor)parts[0]).getTextViewer();
            }
        } else if (part instanceof ObjectMultiPageEditor) {
            viewer = ((ObjectMultiPageEditor)part).getSourceEditor().getTextViewer();
        } else if (part instanceof StructuredTextEditor) {
            viewer = ((StructuredTextEditor)part).getTextViewer();
        }
        return new ELHyperlinkDetector().detectHyperlinks((ITextViewer)viewer, (IRegion)region, true);
    }

    private static TestRegion findOffsetInRegions(int offset, List<TestRegion> regionList) {
        for (TestRegion testRegion : regionList) {
            if (offset < testRegion.region.getOffset() || offset > testRegion.region.getOffset() + testRegion.region.getLength()) continue;
            return testRegion;
        }
        return null;
    }

    private static String findRegionInformation(IDocument document, int offset, List<TestRegion> regionList) throws BadLocationException {
        int index = -1;
        int i = 0;
        while (i < regionList.size()) {
            TestRegion testRegion = regionList.get(i);
            if (offset > testRegion.region.getOffset() + testRegion.region.getLength()) {
                index = i;
            }
            ++i;
        }
        String info = "";
        if (index >= 0) {
            info = "previous region - " + CDIHyperlinkTestUtil.getRegionInformation(document, regionList.get(index));
        }
        if (index + 1 < regionList.size()) {
            info = String.valueOf(info) + " next region - " + CDIHyperlinkTestUtil.getRegionInformation(document, regionList.get(index + 1));
        }
        return info;
    }

    private static String getRegionInformation(IDocument document, TestRegion region) throws BadLocationException {
        String info = "";
        int lineNumber = document.getLineOfOffset(region.region.getOffset());
        int position = region.region.getOffset() - document.getLineOffset(lineNumber) + 1;
        ++lineNumber;
        if (region.regionText != null) {
            info = String.valueOf(info) + "<" + region.regionText + "> ";
        }
        info = String.valueOf(info) + region.region.getOffset() + " - " + (region.region.getOffset() + region.region.getLength()) + " line - " + lineNumber + " position - " + position;
        return info;
    }

    public static IEditorPart openFileInEditor(IFile input) {
        return CDIHyperlinkTestUtil.openFileInEditor(input, null);
    }

    public static IEditorPart openFileInEditor(IFile input, String id) {
        if (input != null && input.exists()) {
            try {
                if (id == null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (boolean)true);
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (String)id, (boolean)true);
            }
            catch (PartInitException pie) {
                pie.printStackTrace();
                CDIHyperlinkTestUtil.fail((String)pie.getMessage());
            }
        }
        return null;
    }

    static class TestContext
    implements IAdaptable {
        ITextEditor editor;

        public TestContext(ITextEditor editor) {
            this.editor = editor;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(ITextEditor.class)) {
                return this.editor;
            }
            return null;
        }
    }

    static class TestData {
        IDocument document;
        int offset;
        IRegion region;
        String contentType;
        private IHyperlinkRegion hyperlinkRegion = null;

        TestData(IDocument document, int offset) {
            this.document = document;
            this.offset = offset;
            this.init();
        }

        private void init() {
            this.region = this.getDocumentRegion();
            this.contentType = this.getContentType();
            this.hyperlinkRegion = this.getHyperlinkRegion();
        }

        private IRegion getDocumentRegion() {
            IRegion region = null;
            try {
                region = JavaWordFinder.findWord((IDocument)this.document, (int)this.offset);
            }
            catch (Exception x) {
                x.printStackTrace();
                CDIHyperlinkTestUtil.fail((String)x.getMessage());
            }
            return region;
        }

        public IHyperlinkRegion getHyperlinkRegion() {
            if (this.hyperlinkRegion != null) {
                return this.hyperlinkRegion;
            }
            return new IHyperlinkRegion(){

                public String getAxis() {
                    return AxisUtil.getAxis((IDocument)TestData.this.document, (int)TestData.this.region.getOffset());
                }

                public String getContentType() {
                    return TestData.this.contentType;
                }

                public String getType() {
                    return TestData.this.region.toString();
                }

                public int getLength() {
                    return TestData.this.region.getLength();
                }

                public int getOffset() {
                    return TestData.this.region.getOffset();
                }

                public String toString() {
                    return "[" + this.getOffset() + "-" + (this.getOffset() + this.getLength() - 1) + ":" + this.getType() + ":" + this.getContentType() + "]";
                }
            };
        }

        private String getContentType() {
            String type = null;
            IModelManager mgr = StructuredModelManager.getModelManager();
            IStructuredModel model = null;
            try {
                model = mgr.getExistingModelForRead(this.document);
                if (model != null) {
                    type = model.getContentTypeIdentifier();
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
            return type;
        }
    }

    public static class TestHyperlink {
        Class<? extends IHyperlink> hyperlink;
        ICDIElement element = null;
        String[] elementPaths = null;
        String name;
        String fileName = null;

        public TestHyperlink(Class<? extends IHyperlink> hyperlink, String name, String fileName) {
            this(hyperlink, name);
            this.fileName = fileName;
        }

        public TestHyperlink(Class<? extends IHyperlink> hyperlink, String name) {
            this.hyperlink = hyperlink;
            this.name = name;
        }

        public TestHyperlink(Class<? extends IHyperlink> hyperlink, String name, ICDIElement element) {
            this(hyperlink, name);
            this.element = element;
        }

        public TestHyperlink(Class<? extends IHyperlink> hyperlink, String name, String[] elementPaths) {
            this(hyperlink, name);
            this.elementPaths = elementPaths;
        }

        public boolean validateHyperlink(IHyperlink hyperlink) {
            if (hyperlink instanceof ITestableCDIHyperlink && ((ITestableCDIHyperlink)hyperlink).getCDIElement() != null && this.element != null) {
                CDIHyperlinkTestUtil.assertEquals((Object)this.element, (Object)((ITestableCDIHyperlink)hyperlink).getCDIElement());
            } else if (hyperlink instanceof ITestableCDIHyperlink && ((ITestableCDIHyperlink)hyperlink).getCDIElements() != null && this.elementPaths != null) {
                for (ICDIElement element : ((ITestableCDIHyperlink)hyperlink).getCDIElements()) {
                    String elementPath = this.findElementPath(this.elementPaths, element);
                    CDIHyperlinkTestUtil.assertNotNull((String)("Unexpected CDI element - " + element.getSourcePath().toString()), (Object)elementPath);
                }
                String[] stringArray = this.elementPaths;
                int n = this.elementPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String elementPath = stringArray[n2];
                    ICDIElement element = this.findCDIElement(((ITestableCDIHyperlink)hyperlink).getCDIElements(), elementPath);
                    CDIHyperlinkTestUtil.assertNotNull((String)("CDI element - " + elementPath + " not found"), (Object)element);
                    ++n2;
                }
            }
            return true;
        }

        protected String findElementPath(String[] elementPaths, ICDIElement element) {
            String[] stringArray = elementPaths;
            int n = elementPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String elementPath = stringArray[n2];
                if (elementPath.equals(element.getSourcePath().toString())) {
                    return elementPath;
                }
                ++n2;
            }
            return null;
        }

        protected ICDIElement findCDIElement(Collection<? extends ICDIElement> elements, String elementPath) {
            for (ICDIElement iCDIElement : elements) {
                if (!elementPath.equals(iCDIElement.getSourcePath().toString())) continue;
                return iCDIElement;
            }
            return null;
        }
    }

    public static class TestRegion {
        IRegion region = null;
        String regionText = null;
        ArrayList<TestHyperlink> hyperlinks = new ArrayList();

        public TestRegion(int offset, int length, TestHyperlink[] testHyperlinks) {
            this.region = new Region(offset, length);
            TestHyperlink[] testHyperlinkArray = testHyperlinks;
            int n = testHyperlinks.length;
            int n2 = 0;
            while (n2 < n) {
                TestHyperlink testHyperlink = testHyperlinkArray[n2];
                this.hyperlinks.add(testHyperlink);
                ++n2;
            }
        }

        public TestRegion(String regionText, TestHyperlink[] testHyperlinks) {
            this.regionText = regionText;
            TestHyperlink[] testHyperlinkArray = testHyperlinks;
            int n = testHyperlinks.length;
            int n2 = 0;
            while (n2 < n) {
                TestHyperlink testHyperlink = testHyperlinkArray[n2];
                this.hyperlinks.add(testHyperlink);
                ++n2;
            }
        }

        public IRegion getRegion() {
            return this.region;
        }
    }
}

