/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.test.tck.TCKTest;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.hyperlink.AssignableBeansHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.InformationControlManager;
import org.jboss.tools.cdi.text.ext.hyperlink.InjectedPointHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.InjectedPointHyperlinkDetector;
import org.jboss.tools.cdi.text.ext.test.CDIHyperlinkTestUtil;
import org.jboss.tools.common.util.FileUtil;

public class InjectedPointHyperlinkDetectorTest
extends TCKTest {
    public void testShowHyperlinksDialog() throws Exception {
        IFile file = this.tckProject.getFile("JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/BasicLogger.java");
        InjectedPointHyperlinkDetectorTest.assertTrue((String)"File must be exist", (boolean)file.exists());
        IEditorPart part = CDIHyperlinkTestUtil.openFileInEditor(file);
        if (part instanceof JavaEditor) {
            IDocument document = ((JavaEditor)part).getViewer().getDocument();
            InjectedPointHyperlinkDetectorTest.assertNotNull((String)"Document not found", (Object)document);
            IBean[] beans = this.cdiProject.getBeans();
            IHyperlink[] hyperlinks = new IHyperlink[beans.length];
            int index = 0;
            IBean[] iBeanArray = beans;
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                IBean b = iBeanArray[n2];
                hyperlinks[index++] = new InjectedPointHyperlink((IRegion)new Region(1, 1), b, document);
                ++n2;
            }
            IInformationControl informationControl = InformationControlManager.instance.showHyperlinks("Title", (ITextViewer)((JavaEditor)part).getViewer(), hyperlinks, true);
            InjectedPointHyperlinkDetectorTest.assertNotNull((String)"InformationControl not found", (Object)informationControl);
            informationControl.setVisible(false);
        } else {
            InjectedPointHyperlinkDetectorTest.fail((String)("Editor part must be instance of JavaEditor, was - " + part.getClass()));
        }
    }

    public void testInjectedPointHyperlinkDetector() throws Exception {
        String[] paths = new String[]{"/tck/JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/BasicLogger.java", "/tck/JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/TimestampLogger.java"};
        Collection beans = this.cdiProject.getBeans("/tck/JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/BasicLogger.java", true);
        IBean bean = null;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            IBean b;
            bean = b = (IBean)iterator.next();
        }
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Inject", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        CDIHyperlinkTestUtil.checkRegions(this.tckProject, "JavaSource/org/jboss/jsr299/tck/tests/lookup/injectionpoint/LoggerConsumer.java", regionList, (IHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }

    public void testInjectedPointHyperlinkDetectorForAsYouType() throws Exception {
        String[] paths = new String[]{"/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/BasicLogger.java", "/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/TestInjections.java"};
        Collection beans = this.cdiProject.getBeans("/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/BasicLogger.java", true);
        IBean bean = null;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            IBean b;
            bean = b = (IBean)iterator.next();
        }
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Inject", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " BasicLogger", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        CDIHyperlinkTestUtil.checkRegionsForAsYouType(this.tckProject, "JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/TestInjections.java", "JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/TestInjections.qfxresult", regionList, (IHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }

    public void testInjectedPointHyperlinkDetectorWithComment() throws Exception {
        String[] paths = new String[]{"/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/BasicFood.java", "/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/AdvancedFood.java"};
        Collection beans = this.cdiProject.getBeans("/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/AdvancedFood.java", true);
        IBean bean = null;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            IBean b;
            bean = b = (IBean)iterator.next();
        }
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Inject", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " AdvancedFood.ff", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Food", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " AdvancedFood.ff", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("food", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " AdvancedFood.ff", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("food", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " AdvancedFood.ff", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("food", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " AdvancedFood.ff", (ICDIElement)bean), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE, paths)}));
        CDIHyperlinkTestUtil.checkRegions(this.tckProject, "JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/FoodConsumer.java", regionList, (IHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }

    public void testInjectedProducerMethodParametersHyperlinkDetector() throws Exception {
        Collection beans = this.cdiProject.getBeans("/tck/JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/CustomProducerImpl.java", true);
        IBean bean = null;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            IBean b;
            bean = b = (IBean)iterator.next();
        }
        IFile file = this.tckProject.getFile("JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/CustomProducerImpl.java");
        String text = FileUtil.readStream((IFile)file);
        int orderPosition = text.indexOf("Something order");
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion(orderPosition, 15, new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " CustomProducerImpl.produce()", (ICDIElement)bean)}));
        String disposesParam = "Disposes Something toDispose";
        int disposePosition = text.indexOf(disposesParam);
        regionList.add(new CDIHyperlinkTestUtil.TestRegion(disposePosition, disposesParam.length(), new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " CustomProducerImpl.produce()", (ICDIElement)bean)}));
        CDIHyperlinkTestUtil.checkRegions(this.tckProject, "JavaSource/org/jboss/jsr299/tck/tests/jbt/openon/CustomProducerImpl.java", regionList, (IHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }

    public void testInjectedConstructorParametersHyperlinkDetector() throws Exception {
        Collection beans = this.cdiProject.getBeans("/tck/JavaSource/org/jboss/jsr299/tck/tests/context/dependent/Fox.java", true);
        IBean bean = null;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            IBean b;
            bean = b = (IBean)iterator.next();
        }
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Inject", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("FoxFarm", new CDIHyperlinkTestUtil.TestHyperlink[0]));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        CDIHyperlinkTestUtil.checkRegions(this.tckProject, "JavaSource/org/jboss/jsr299/tck/tests/context/dependent/FoxFarm.java", regionList, (IHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }

    public void testInjectedInitializerParametersHyperlinkDetector() throws Exception {
        Collection beans = this.cdiProject.getBeans("/tck/JavaSource/org/jboss/jsr299/tck/tests/context/dependent/Fox.java", true);
        IBean bean = null;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            IBean b;
            bean = b = (IBean)iterator.next();
        }
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Inject", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("init(", new CDIHyperlinkTestUtil.TestHyperlink[0]));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("fox", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " Fox", (ICDIElement)bean)}));
        CDIHyperlinkTestUtil.checkRegions(this.tckProject, "JavaSource/org/jboss/jsr299/tck/tests/context/dependent/FoxHole.java", regionList, (IHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }

    public void testInjectedPointHyperlinkDetectorForJAR() throws Exception {
        ArrayList<CDIHyperlinkTestUtil.TestRegion> regionList = new ArrayList<CDIHyperlinkTestUtil.TestRegion>();
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("Inject", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " JarBasicLogger"), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("JarLogger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " JarBasicLogger"), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " JarBasicLogger"), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " JarBasicLogger"), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE)}));
        regionList.add(new CDIHyperlinkTestUtil.TestRegion("logger", new CDIHyperlinkTestUtil.TestHyperlink[]{new CDIHyperlinkTestUtil.TestHyperlink(InjectedPointHyperlink.class, String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " JarBasicLogger"), new CDIHyperlinkTestUtil.TestHyperlink(AssignableBeansHyperlink.class, CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ASSIGNABLE)}));
        CDIHyperlinkTestUtil.checkRegionsInJar(this.tckProject, "org.jar.test.openon.JarLoggerConsumer", regionList, (AbstractHyperlinkDetector)new InjectedPointHyperlinkDetector());
    }
}

