/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.test;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.vpe.base.test.TestUtil;
import org.jboss.tools.vpe.base.test.VpeTest;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;

public class RichFacesComboBoxTemplateTestCase
extends VpeTest {
    private static final String _150PX = "150px";
    private static final String _250PX = "250px";
    private static final String _255PX = "255px";
    private static final String COMPONENTS_COMBO_BOX_WITHOUT_ATTR = "components/comboBox/comboBox.xhtml";
    private static final String COMPONENTS_COMBO_WITH_ATTR_TEMPLATE = "components/comboBox/comboBoxWithAttributes.xhtml";
    private static final String COMPONENTS_COMBO_WITH_ATTR_TEMPLATE2 = "components/comboBox/comboBoxWithAttributes2.xhtml";
    private static final String DEFAULT_INPUT_STYLE = "rich-combobox-font-disabled rich-combobox-input-inactive";
    private static final String DEFAULT_WIDTH = "width: 150px;";
    private static final String EL_VALUE = "#{bean.value}";
    private static final String SELECT_ANY_VALUE = "Select Any Value";
    private static final int ZERO = 0;

    private nsIDOMElement baseTableCheck(String page, String width) throws PartInitException, Throwable {
        nsIDOMElement rst = TestUtil.performTestForRichFacesComponent((IFile)((IFile)TestUtil.getComponentPath((String)page, (String)"richFacesTest")));
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)rst, elements, (String)"div");
        nsIDOMElement divOne = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(5)), nsIDOMElement.class);
        Assert.assertTrue((String)"Style classes should be contains ", (boolean)divOne.getAttribute("class").contains("rich-combobox-font rich-combobox"));
        Assert.assertTrue((String)("Default style should be contains " + width), (divOne.getAttribute("style").indexOf(width) > 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Default style should be contains " + width), (boolean)divOne.getAttribute("style").contains("width"));
        return rst;
    }

    private void checkValueInInput(nsIDOMElement rst, String inputValue) {
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)rst, elements, (String)"input");
        Assert.assertEquals((String)"Size should be equals 2", (long)3L, (long)elements.size());
        nsIDOMElement input = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(0)), nsIDOMElement.class);
        Assert.assertEquals((String)("Value should be equals " + inputValue), (Object)inputValue, (Object)input.getAttribute("value"));
    }

    @Test
    public void testComboBoxWithAttributes() throws PartInitException, Throwable {
        nsIDOMElement rst = this.baseTableCheck(COMPONENTS_COMBO_WITH_ATTR_TEMPLATE, _250PX);
        this.checkValueInInput(rst, SELECT_ANY_VALUE);
    }

    @Test
    public void testComboBoxWithAttributes2() throws PartInitException, Throwable {
        nsIDOMElement rst = this.baseTableCheck(COMPONENTS_COMBO_WITH_ATTR_TEMPLATE2, _255PX);
        this.checkValueInInput(rst, EL_VALUE);
    }

    @Test
    public void testComboBoxWithoutAttributes() throws PartInitException, Throwable {
        nsIDOMElement rst = this.baseTableCheck(COMPONENTS_COMBO_BOX_WITHOUT_ATTR, _150PX);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)rst, elements, (String)"input");
        Assert.assertEquals((String)"Size should be equals 2", (long)3L, (long)elements.size());
        nsIDOMElement input = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(0)), nsIDOMElement.class);
        Assert.assertEquals((String)"Default input class should be equals rich-combobox-font-disabled rich-combobox-input-inactive", (Object)input.getAttribute("class"), (Object)DEFAULT_INPUT_STYLE);
    }
}

