/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.adopt;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.SourceViewer;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.adopt.JSPAdoptHelper;
import org.jboss.tools.jsf.ui.adopt.JSPTokenizer;
import org.jboss.tools.jsf.ui.adopt.Token;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;

public class JSPAdopt
implements XAdoptManager {
    private static final String JSF_NATURE_STRING = "org.jboss.tools.jsf.jsfnature";
    private static final String JSF_CORE_TAGLIB_URI = "http://java.sun.com/jsf/core";
    private static final String JSF_CORE_TAGLIB_PREFIX_DEFAULT = "f";
    private static final String JSF_HTML_TAGLIB_URI = "http://java.sun.com/jsf/html";
    private static final String JSF_HTML_TAGLIB_PREFIX_DEFAULT = "h";

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        return this.isAdoptableProperty(object) || this.isAdoptableNature(target) && this.isAdoptableBundle(object);
    }

    protected boolean isAdoptableProperty(XModelObject object) {
        String entity = object.getModelEntity().getName();
        return "Property".equals(entity);
    }

    protected boolean isAdoptableNature(XModelObject target) {
        if (target == null) {
            return false;
        }
        String nature = (String)target.getModel().getProperties().get("nature");
        return JSF_NATURE_STRING.equalsIgnoreCase(nature);
    }

    protected boolean isAdoptableBundle(XModelObject object) {
        return "FilePROPERTIES".equals(object.getModelEntity().getName());
    }

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (this.isAdoptableProperty(object)) {
            this.adoptProperty(target, object, p);
        }
        if (this.isAdoptableBundle(object)) {
            this.adoptBundle(target, object, p);
        }
    }

    public void adoptProperty(XModelObject target, XModelObject object, Properties p) {
        SourceViewer viewer;
        String name = object.getAttributeValue("name");
        String bundle = this.getBundle(object.getParent());
        int pos = -1;
        try {
            String s;
            String string = s = p == null ? null : p.getProperty("pos");
            if (s != null && s.length() > 0) {
                pos = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
        if ((viewer = (SourceViewer)p.get("viewer")) == null) {
            JsfUiPlugin.getPluginLog().logError("Viewer is null", (Throwable)new NullPointerException("Viewer is null"));
            return;
        }
        if (viewer.getDocument() == null) {
            return;
        }
        JSPTokenizer tokenizer = new JSPTokenizer();
        Token root = tokenizer.parse(viewer.getDocument());
        Token t = root.firstChild;
        while (t != null) {
            t = t.nextSibling;
        }
        int contextIndex = this.getContextIndex(tokenizer, pos);
        if (pos < 0) {
            return;
        }
        String jsfCorePrefix = JSPAdoptHelper.getPrefixForURI(root, JSF_CORE_TAGLIB_URI, JSF_CORE_TAGLIB_PREFIX_DEFAULT);
        String jsfHtmlPrefix = JSPAdoptHelper.getPrefixForURI(root, JSF_HTML_TAGLIB_URI, JSF_HTML_TAGLIB_PREFIX_DEFAULT);
        String prefix = "???";
        String varValue = JSPAdoptHelper.getLoadedBundleVar(root, jsfCorePrefix, bundle);
        if (varValue != null && varValue.length() > 0) {
            prefix = varValue;
        }
        if (prefix.equals("???")) {
            Map map;
            WebPromptingProvider fProvider = WebPromptingProvider.getInstance();
            List l = fProvider.getList(target.getModel(), "jsf.registered.bundles", null, null);
            int map_index = 1;
            Map map2 = map = l.size() <= map_index ? null : (Map)l.get(map_index);
            if (map != null && map.containsKey(bundle)) {
                prefix = map.get(bundle).toString();
            }
        }
        tokenizer.isInTagAttributeValue(pos);
        if (prefix.equals("???")) {
            int bp = JSPAdoptHelper.getPositionForBundle(root, jsfCorePrefix);
            if (bp < 0) {
                return;
            }
            prefix = JSPAdoptHelper.getNameForNewBundle(root, jsfCorePrefix);
            String loadBundle = "\n" + this.createLoadBundleTag(jsfCorePrefix, bundle, prefix);
            try {
                viewer.getDocument().replace(bp, 0, loadBundle);
                if (pos >= bp) {
                    pos += loadBundle.length();
                }
            }
            catch (BadLocationException e) {
                JsfUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        String start = this.getPropertyReference(prefix, name);
        if (contextIndex == 1) {
            start = "<" + jsfHtmlPrefix + ":outputText value=\"" + start + "\"/>";
        }
        try {
            viewer.getDocument().replace(pos, 0, start);
            viewer.setSelectedRange(pos, 0);
            viewer.getTextWidget().setFocus();
        }
        catch (BadLocationException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
        p.remove("start text");
    }

    private String getPropertyReference(String prefix, String name) {
        return !this.isJavaName(name) ? "#{" + prefix + "['" + name + "']}" : "#{" + prefix + "." + name + "}";
    }

    private boolean isJavaName(String name) {
        if (name.length() == 0) {
            return true;
        }
        char ch = name.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getContextIndex(JSPTokenizer tokenizer, int pos) {
        if (tokenizer.root == null) {
            return -1;
        }
        if (tokenizer.isInTagAttributeValue(pos)) {
            return 0;
        }
        Token e = tokenizer.getTokenAt(pos);
        if (e == null) {
            return -1;
        }
        if (e.kind == JSPTokenizer.TEXT || pos == e.off) {
            return 1;
        }
        return -1;
    }

    private String createLoadBundleTag(String jsfCorePrefix, String bundlePath, String var) {
        return "<" + jsfCorePrefix + ":loadBundle basename=\"" + bundlePath + "\" var=\"" + var + "\" />";
    }

    public void adoptBundle(XModelObject target, XModelObject object, Properties p) {
        SourceViewer viewer;
        if (p == null) {
            return;
        }
        String bundle = this.getBundle(object);
        int pos = -1;
        try {
            String s;
            String string = s = p == null ? null : p.getProperty("pos");
            if (s != null && s.length() > 0) {
                pos = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
        if ((viewer = (SourceViewer)p.get("viewer")) == null || viewer.getDocument() == null) {
            return;
        }
        JSPTokenizer tokenizer = new JSPTokenizer();
        Token root = tokenizer.parse(viewer.getDocument());
        int contextIndex = this.getContextIndex(tokenizer, pos);
        String start = bundle;
        if (contextIndex == 1) {
            String jsfCorePrefix = JSPAdoptHelper.getPrefixForURI(root, JSF_CORE_TAGLIB_URI, JSF_CORE_TAGLIB_PREFIX_DEFAULT);
            start = this.createLoadBundleTag(jsfCorePrefix, bundle, "|");
        }
        p.setProperty("start text", start);
        p.setProperty("end text", "");
    }

    String getBundle(XModelObject file) {
        int i;
        String bundle = XModelObjectLoaderUtil.getResourcePath((XModelObject)file);
        if (bundle == null) {
            bundle = "";
        }
        if (bundle.endsWith(".properties")) {
            bundle = bundle.substring(0, bundle.length() - 11);
        }
        if ((i = (bundle = bundle.substring(1).replace('/', '.')).indexOf(95)) >= 0) {
            bundle = bundle.substring(0, i);
        }
        return bundle;
    }
}

