/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.check;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.check.ProjectNaturesInfoDialog;
import org.jboss.tools.jsf.ui.editor.check.wizards.AddJSFCapabilitiesWizard;

public class JSFNaturesInfoDialog
extends ProjectNaturesInfoDialog {
    public JSFNaturesInfoDialog(IProject project) {
        super(project, JsfUIMessages.ADD_JSF_CAPABILITIES_BUTTTON_LABEL);
    }

    @Override
    protected void fixButtonPressed() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AddJSFCapabilitiesWizard.getInstance(JSFNaturesInfoDialog.this.project).execute(null);
                }
                catch (ExecutionException e) {
                    JsfUiPlugin.getPluginLog().logError((Throwable)e);
                }
            }
        });
    }

    @Override
    protected String getMessageInfo() {
        String dialogMessage = MessageFormat.format(JsfUIMessages.ENABLE_JSF_CAPABILITIES_TEXT, this.project.getName());
        return dialogMessage;
    }

    @Override
    protected void skipButtonPressed() {
        try {
            String value = !this.isRemember ? "yes" : "no";
            Preference.SHOW_NATURE_WARNING.setValue(value);
        }
        catch (XModelException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

