/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.check;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.jboss.tools.common.reporting.ProblemReportingHelper;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public abstract class ProjectNaturesInfoDialog
extends MessageDialog {
    private Button button;
    private Link link;
    protected boolean isRemember = false;
    protected IProject project;

    protected ProjectNaturesInfoDialog(IProject project, String fixButtonLabel) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), JsfUIMessages.MISSING_NATURES_INFO_MESSAGE_TITLE, null, "", 2, new String[]{fixButtonLabel, JsfUIMessages.SKIP_BUTTON_LABEL}, 0);
        this.project = project;
        this.message = this.getMessageInfo();
    }

    protected Control createCustomArea(Composite parent) {
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        this.button = new Button(parent, 32);
        GridData gridData = new GridData(32);
        this.button.setLayoutData((Object)gridData);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.isRemember = !ProjectNaturesInfoDialog.this.isRemember;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.isRemember = !ProjectNaturesInfoDialog.this.isRemember;
            }
        });
        this.button.setText(JsfUIMessages.DONT_SHOW_CHECKER_DIALOG);
        this.link = new Link(parent, 0);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        this.link.setLayoutData((Object)gridData);
        this.link.setText("<A>" + JstUIMessages.DOCS_INFO_LINK_TEXT + "</A>");
        this.link.setToolTipText(JstUIMessages.DOCS_INFO_LINK);
        this.link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.processLink(ProjectNaturesInfoDialog.this.link);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.processLink(ProjectNaturesInfoDialog.this.link);
            }
        });
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            this.fixButtonPressed();
        }
        if (buttonId == 1) {
            this.skipButtonPressed();
        }
    }

    private void processLink(Link link) {
        BusyIndicator.showWhile((Display)link.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                URL theURL = null;
                try {
                    theURL = new URL(JstUIMessages.DOCS_INFO_LINK);
                }
                catch (MalformedURLException e) {
                    ProblemReportingHelper.reportProblem((String)"org.jboss.tools.jst.web.ui", (Throwable)e);
                }
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    support.getExternalBrowser().openURL(theURL);
                }
                catch (PartInitException e) {
                    ProblemReportingHelper.reportProblem((String)"org.jboss.tools.jst.web.ui", (Throwable)e);
                }
            }
        });
    }

    protected abstract String getMessageInfo();

    protected abstract void fixButtonPressed();

    protected abstract void skipButtonPressed();
}

