/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;
import org.jboss.tools.jsf.JSFPreference;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementList;
import org.jboss.tools.jsf.ui.editor.model.IJSFModel;
import org.jboss.tools.jsf.ui.editor.model.IJSFModelListener;
import org.jboss.tools.jsf.ui.editor.model.IJSFOptions;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.IPage;
import org.jboss.tools.jsf.ui.editor.model.impl.Group;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElement;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElementList;
import org.jboss.tools.jsf.ui.editor.model.impl.Link;
import org.jboss.tools.jsf.ui.preferences.JSFFlowTabbedPreferencesPage;

public class JSFModel
extends JSFElement
implements IJSFModel,
PropertyChangeListener,
XModelTreeListener {
    protected List<IJSFModelListener> strutsModelListeners = new Vector<IJSFModelListener>();
    protected JSFHashtable map = new JSFHashtable();
    protected JSFElementList processItemList = new ProcessItemList();
    protected JSFProcessStructureHelper helper = JSFProcessStructureHelper.instance;
    protected JSFOptions options;
    protected boolean modified = false;
    IGroup selectedGroup = null;
    XModelTreeListenerSWTSync listener = null;

    public JSFModel() {
        try {
            this.setName("Struts Model");
        }
        catch (PropertyVetoException ex) {
            JsfUiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    @Override
    public void dispose() {
        this.disconnectFromModel();
        if (this.map != null) {
            this.map.dispose();
        }
        this.map = null;
        if (this.strutsModelListeners != null) {
            this.strutsModelListeners.clear();
        }
        this.strutsModelListeners = null;
        if (this.processItemList != null) {
            this.processItemList.dispose();
        }
        this.processItemList = null;
        if (this.options != null) {
            this.options.dispose();
        }
        this.options = null;
    }

    @Override
    public boolean isBorderPaint() {
        return false;
    }

    @Override
    public IJSFOptions getOptions() {
        return this.options;
    }

    public JSFModel(Object data) {
        this();
        this.setData(((XModelObject)data).getChildByPath("process"));
        this.map.setData((XModelObject)data);
    }

    @Override
    public void updateLinks() {
        int i = 0;
        while (i < this.getGroupList().size()) {
            IGroup group = (IGroup)this.getGroupList().get(i);
            int j = 0;
            while (j < group.getPageList().size()) {
                IPage page = (IPage)group.getPageList().get(j);
                int k = 0;
                while (k < page.getLinkList().size()) {
                    ((ILink)page.getLinkList().get(k)).setTarget();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public Object get(String name) {
        return null;
    }

    public void put(String name, Object value) {
    }

    @Override
    public JSFProcessStructureHelper getHelper() {
        return this.helper;
    }

    public int getProcessItemCounter() {
        return this.processItemList.size();
    }

    public IGroup getGroup(int index) {
        return (IGroup)this.processItemList.get(index);
    }

    @Override
    public IGroup getGroup(String groupName) {
        return (IGroup)this.processItemList.get(groupName);
    }

    @Override
    public IGroup getGroup(Object source) {
        IGroup[] is = this.processItemList.elements.toArray(new IGroup[0]);
        int i = 0;
        while (i < is.length) {
            if (is[i].getSource() == source) {
                return is[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void removeGroup(String moduleName) {
    }

    @Override
    public void removeGroup(IGroup removeProcessItem) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }

    @Override
    public void setSelectedProcessItem(IGroup group) {
        IGroup oldValue = this.selectedGroup;
        this.selectedGroup = group;
        this.propertyChangeSupport.firePropertyChange("selectedProcessItem", oldValue, group);
    }

    @Override
    public IGroup getSelectedProcessItem() {
        return this.selectedGroup;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setData(Object data) {
        this.source = (XModelObject)data;
        if (this.source == null) {
            return;
        }
        this.helper.autolayout(this.source);
        this.map.put(this.source.getPath(), this);
        this.processItemList = new ProcessItemList(this.source);
        this.listener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
        this.source.getModel().addModelTreeListener((XModelTreeListener)this.listener);
        this.options = new JSFOptions();
    }

    public void disconnectFromModel() {
        if (this.listener != null) {
            this.source.getModel().removeModelTreeListener((XModelTreeListener)this.listener);
        }
        if (this.options != null) {
            this.options.disconnectFromModel();
        }
        if (this.map != null) {
            this.map.disconnectFromModel();
        }
    }

    @Override
    public boolean isEditable() {
        return this.source != null && this.source.getModelEntity().isEditable(this.source, "body");
    }

    @Override
    public boolean areCommentsVisible() {
        return false;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean set) {
        boolean oldValue = this.modified;
        this.modified = set;
        this.propertyChangeSupport.firePropertyChange("modified", oldValue, this.modified);
    }

    public void fireProcessChanged(boolean flag) {
        if (this.strutsModelListeners == null) {
            return;
        }
        ArrayList<IJSFModelListener> targets = new ArrayList<IJSFModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            IJSFModelListener listener = (IJSFModelListener)targets.get(i);
            if (listener != null) {
                listener.processChanged(flag);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireProcessItemAdd(IGroup newProcessItem) {
        ArrayList<IJSFModelListener> targets = new ArrayList<IJSFModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            IJSFModelListener listener = (IJSFModelListener)targets.get(i);
            if (listener != null) {
                listener.groupAdd(newProcessItem);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireProcessItemRemove(IGroup newProcessItem, int index) {
        ArrayList<IJSFModelListener> targets = new ArrayList<IJSFModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            IJSFModelListener listener = (IJSFModelListener)targets.get(i);
            if (listener != null) {
                listener.groupRemove(newProcessItem);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireLinkAdd(ILink newLink) {
        ArrayList<IJSFModelListener> targets = new ArrayList<IJSFModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            IJSFModelListener listener = (IJSFModelListener)targets.get(i);
            if (listener != null) {
                listener.linkAdd(newLink);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireLinkRemove(ILink newLink) {
        ArrayList<IJSFModelListener> targets = new ArrayList<IJSFModelListener>();
        targets.addAll(this.strutsModelListeners);
        int i = 0;
        while (i < targets.size()) {
            IJSFModelListener listener = (IJSFModelListener)targets.get(i);
            if (listener != null) {
                listener.linkRemove(newLink);
            }
            ++i;
        }
        this.setModified(true);
    }

    public void fireElementRemoved(IJSFElement element, int index) {
    }

    public void fireElementInserted(IJSFElement element) {
    }

    @Override
    public void addJSFModelListener(IJSFModelListener listener) {
        this.strutsModelListeners.add(listener);
    }

    @Override
    public void removeJSFModelListener(IJSFModelListener listener) {
        if (this.strutsModelListeners != null) {
            this.strutsModelListeners.remove(listener);
        }
    }

    @Override
    public void remove() {
    }

    @Override
    public String getIconPath() {
        return null;
    }

    @Override
    public IGroup addGroup(IGroup group) {
        return null;
    }

    @Override
    public IGroup addGroup(String group) {
        return null;
    }

    @Override
    public IGroup addGroup(Object source, int x, int y) {
        return null;
    }

    @Override
    public IGroup addGroup(IJSFElement element) {
        return null;
    }

    @Override
    public IJSFElementList getGroupList() {
        return this.processItemList;
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path;
        this.fireProcessChanged(false);
        if (this.map == null || event == null) {
            return;
        }
        JSFElement element = (JSFElement)this.map.get(event.getInfo());
        if (element != null && !event.getModelObject().getPath().equals(event.getInfo())) {
            this.updateCash((String)event.getInfo());
        }
        IJSFElement iJSFElement = element = (path = event.getModelObject().getPath()) == null ? null : this.map.get(path);
        if (element == null) {
            return;
        }
        element.nodeChanged(event);
    }

    public void structureChanged(XModelTreeEvent event) {
        String obj = event.getModelObject().getPath();
        if (obj == null) {
            return;
        }
        if (this.map == null) {
            return;
        }
        JSFElement element = (JSFElement)this.map.get(obj);
        if (element == null) {
            return;
        }
        if (event.kind() == 3) {
            element.structureChanged(event);
        } else if (event.kind() == 1) {
            element.nodeAdded(event);
        } else if (event.kind() == 2) {
            element.nodeRemoved(event);
        }
    }

    public void putToMap(Object key, IJSFElement value) {
        this.getMap().put(key, value);
    }

    @Override
    public void removeFromMap(Object key) {
        this.getMap().remove(key);
    }

    @Override
    public IJSFElement getFromMap(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public JSFHashtable getMap() {
        return this.map;
    }

    @Override
    public IJSFElement findElement(String key) {
        return this.map.get(key);
    }

    protected void clearCash(String path) {
        this.updateCash(path, true);
    }

    protected void updateCash(String path) {
        this.updateCash(path, false);
    }

    protected void updateCash(String path, boolean clear) {
        String rpath = String.valueOf(path) + "/";
        Object[] ks = this.map.map.keySet().toArray();
        int i = 0;
        while (i < ks.length) {
            if (ks[i].equals(path) || ks[i].toString().startsWith(rpath)) {
                XModelObject o;
                IJSFElement n = (IJSFElement)this.map.map.get(ks[i]);
                this.map.map.remove(ks[i]);
                if (!clear && (o = (XModelObject)n.getSource()).isActive()) {
                    this.map.map.put(o.getPath(), n);
                }
            }
            ++i;
        }
    }

    @Override
    public Menu getPopupMenu(Control control, Object environment) {
        if (this.source == null) {
            return null;
        }
        if (this.source.getModelEntity().getActionList().getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(this.source.getModelEntity().getActionList(), this.source, null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    @Override
    public Menu getPopupMenu(Control control) {
        return this.getPopupMenu(control, null);
    }

    @Override
    public boolean isConfirmed() {
        return true;
    }

    public class JSFHashtable
    implements XModelTreeListener {
        private Hashtable<Object, IJSFElement> map = new Hashtable();
        XModelObject source;
        String name;

        public void dispose() {
            this.disconnectFromModel();
            if (this.map != null) {
                this.map.clear();
            }
            this.map = null;
        }

        public void put(Object key, IJSFElement value) {
            this.map.put(key, value);
        }

        public void setData(XModelObject data) {
            this.source = data;
            this.source.getModel().addModelTreeListener((XModelTreeListener)this);
            this.name = this.source.getAttributeValue("name");
        }

        public void disconnectFromModel() {
            this.source.getModel().removeModelTreeListener((XModelTreeListener)this);
        }

        public IJSFElement get(Object key) {
            return this.map.get(key);
        }

        public void remove(Object key) {
            this.map.remove(key);
        }

        public void nodeChanged(XModelTreeEvent event) {
            if (!this.source.getAttributeValue("name").equals(this.name)) {
                this.name = this.source.getAttributeValue("name");
                Enumeration<Object> keys = this.map.keys();
                while (keys.hasMoreElements()) {
                    String path;
                    JSFElement element;
                    Object key = keys.nextElement();
                    if (!(key instanceof String) || (element = (JSFElement)this.map.get(path = (String)key)) == null || element.getSource() == null) continue;
                    this.map.remove(path);
                    this.map.put(((XModelObject)element.getSource()).getPath(), element);
                }
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }

    class JSFOptions
    implements XModelTreeListener,
    IJSFOptions {
        XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(JSFFlowTabbedPreferencesPage.JSF_EDITOR_PATH);
        XModelTreeListenerSWTSync optionsListener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
        Font viewPathFont = null;
        Font linkPathFont = null;

        public JSFOptions() {
            this.optionsObject.getModel().addModelTreeListener((XModelTreeListener)this.optionsListener);
        }

        public void dispose() {
            this.disconnectFromModel();
            if (this.linkPathFont != null && this.linkPathFont.isDisposed()) {
                this.linkPathFont.dispose();
            }
            this.linkPathFont = null;
            if (this.viewPathFont != null && this.viewPathFont.isDisposed()) {
                this.viewPathFont.dispose();
            }
            this.viewPathFont = null;
        }

        @Override
        public boolean isGridVisible() {
            String str = this.optionsObject.getAttributeValue("Show Grid");
            return str.equals("yes");
        }

        @Override
        public int getGridStep() {
            return 8;
        }

        @Override
        public int getVisualGridStep() {
            String str = this.optionsObject.getAttributeValue("Grid Step");
            return Integer.parseInt(str);
        }

        @Override
        public Font getLinkPathFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = this.optionsObject.getAttributeValue("Link Path Font");
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.linkPathFont == null) {
                this.linkPathFont = new Font(null, name, size, style);
            } else if (!this.linkPathFont.getFontData()[0].getName().equals(name) || this.linkPathFont.getFontData()[0].getHeight() != size || this.linkPathFont.getFontData()[0].getStyle() != style) {
                this.linkPathFont = new Font(null, name, size, style);
            }
            return this.linkPathFont;
        }

        @Override
        public Font getViewPathFont() {
            String name;
            int size = 8;
            int style = 1;
            String str = this.optionsObject.getAttributeValue("View Path Font");
            int pos = str.indexOf(",");
            if (pos < 0) {
                name = str;
            } else {
                int pos3;
                name = str.substring(0, pos);
                int pos2 = str.indexOf("size=");
                if (pos2 >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    size = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 5, str.length())) : Integer.parseInt(str.substring(pos2 + 5, pos3));
                }
                if ((pos2 = str.indexOf("style=")) >= 0) {
                    pos3 = str.indexOf(",", pos2);
                    style = pos3 < 0 ? Integer.parseInt(str.substring(pos2 + 6, str.length())) : Integer.parseInt(str.substring(pos2 + 6, pos3));
                }
            }
            if (this.viewPathFont == null) {
                this.viewPathFont = new Font(null, name, size, style);
            } else if (!this.viewPathFont.getFontData()[0].getName().equals(name) || this.viewPathFont.getFontData()[0].getHeight() != size || this.viewPathFont.getFontData()[0].getStyle() != style) {
                this.viewPathFont = new Font(null, name, size, style);
            }
            return this.viewPathFont;
        }

        public void disconnectFromModel() {
            this.optionsObject.getModel().removeModelTreeListener((XModelTreeListener)this.optionsListener);
            if (this.optionsListener != null) {
                this.optionsListener.dispose();
            }
            this.optionsListener = null;
        }

        public void nodeChanged(XModelTreeEvent event) {
            JSFModel.this.fireProcessChanged(false);
            int i = 0;
            while (i < JSFModel.this.getGroupList().size()) {
                Group group = (Group)JSFModel.this.getGroupList().get(i);
                group.fireGroupChange();
                int j = 0;
                while (j < group.getListOutputLinks().size()) {
                    ((Link)group.getListOutputLinks().get(j)).fireLinkChange();
                    ++j;
                }
                ++i;
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }

        @Override
        public boolean switchToSelectionTool() {
            String str = JSFPreference.ENABLE_CONTROL_MODE_ON_TRANSITION_COMPLETED.getValue();
            return str != null && str.equals("yes");
        }

        @Override
        public boolean showShortcutIcon() {
            String str = JSFPreference.SHOW_SHORTCUT_ICON.getValue();
            return str != null && str.equals("yes");
        }

        @Override
        public boolean showShortcutPath() {
            String str = JSFPreference.SHOW_SHORTCUT_PATH.getValue();
            return str != null && str.equals("yes");
        }
    }

    public class ProcessItemList
    extends JSFElementList {
        protected ProcessItemList() {
        }

        public ProcessItemList(XModelObject processItemSource) {
            super(JSFModel.this, JSFModel.this.source);
            if (((XModelObject)JSFModel.this.getSource()).getPath() == null) {
                return;
            }
            XModelObject[] processItemNodeList = JSFModel.this.getHelper().getGroups(JSFModel.this.source);
            int i = 0;
            while (i < processItemNodeList.length) {
                Group newProcessItem = new Group((IJSFModel)JSFModel.this, processItemNodeList[i]);
                newProcessItem.addPropertyChangeListener("selected", new ProcessItemPropertyChangeListener());
                this.add(newProcessItem);
                ++i;
            }
        }

        @Override
        public void structureChanged(Object eventData) {
        }

        @Override
        public void nodeAdded(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            Group newProcessItem = new Group((IJSFModel)JSFModel.this, (XModelObject)event.getInfo());
            this.add(newProcessItem);
            JSFModel.this.fireProcessItemAdd(newProcessItem);
        }

        @Override
        public void nodeRemoved(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            IJSFElement removedProcessItem = this.getFromMap(event.getInfo());
            int index = this.indexOf(removedProcessItem);
            removedProcessItem.remove();
            this.remove(removedProcessItem);
            this.removeFromMap(((XModelTreeEvent)eventData).getInfo());
            JSFModel.this.fireProcessItemRemove((Group)removedProcessItem, index);
            JSFModel.this.clearCash((String)event.getInfo());
        }
    }

    public class ProcessItemPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            IGroup processItem = (IGroup)event.getSource();
            if (event.getPropertyName().equals("selected") && ((Boolean)event.getNewValue()).booleanValue()) {
                JSFModel.this.setSelectedProcessItem(processItem);
            }
        }
    }
}

