/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.navigator;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.jsf.model.pv.JSFProjectTagLibs;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.jst.web.tld.model.TLDUtil;

public class JsfProjectsTreeListener
extends TreeViewerModelListenerImpl {
    public void nodeChanged(XModelTreeEvent event) {
        WebProjectNode n;
        XModelObject source = event.getModelObject();
        JSFProjectsRoot root = (JSFProjectsRoot)this.getProjectRoot(source.getModel());
        if (root == null) {
            return;
        }
        if (!root.isLoaded()) {
            if (source.getFileType() != 0) {
                super.updateNode((XModelObject)root);
            }
            return;
        }
        if (source.getModelEntity().getName().startsWith("FileWebApp")) {
            n = this.getProjectRoot(source.getModel());
            if (n != null) {
                n.invalidate();
            }
        } else if (JSFProjectTagLibs.isTLDFile((XModelObject)source)) {
            this.invalidateTagLibs(source.getModel());
            super.nodeChanged(event);
        } else {
            super.nodeChanged(event);
        }
        if (!(source instanceof WebProjectNode)) {
            n = this.getProjectRoot(source.getModel());
            if (n == null) {
                return;
            }
            XModelObject p = n.getTreeParent(source);
            if (p instanceof WebProjectNode) {
                ((XModelImpl)p.getModel()).fireNodeChanged(p, p.getPath());
            }
        }
    }

    protected WebProjectNode getProjectRoot(XModel model) {
        return (WebProjectNode)model.getByPath("root:JSFProjects");
    }

    public void structureChanged(XModelTreeEvent event) {
        String entity;
        if (this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        XModelObject source = event.getModelObject();
        JSFProjectsRoot root = (JSFProjectsRoot)this.getProjectRoot(source.getModel());
        if (root == null || !root.isLoaded()) {
            return;
        }
        if (event.kind() == 1) {
            WebProjectNode n;
            XModelObject c = (XModelObject)event.getInfo();
            String entity2 = c.getModelEntity().getName();
            if ("FilePROPERTIES".equals(c.getModelEntity().getName())) {
                this.invalidateBundles(source.getModel());
            } else if (JSFProjectTagLibs.isTLDFile((XModelObject)c) || TLDUtil.isFaceletTaglib((XModelObject)c) || "FileSystemJar".equals(entity2)) {
                this.invalidateTagLibs(source.getModel());
            } else if (entity2.startsWith("FacesConfig")) {
                this.invalidateConfig(source.getModel());
            } else if ("JSFManagedBean".equals(entity2) || "JSFManagedBean20".equals(entity2)) {
                this.invalidateFolder(source.getModel(), "Beans");
            } else if ("JSFReferencedBean".equals(entity2)) {
                this.invalidateFolder(source.getModel(), "Beans");
            } else if ("FileTiles".equals(entity2)) {
                this.invalidateFolder(source.getModel(), "Tiles");
            } else if ("FileFolder".equals(entity2) && (n = this.getProjectRoot(source.getModel())) != null) {
                n.invalidate();
            }
        } else if (event.kind() == 2) {
            String entity3 = source.getModelEntity().getName();
            if (source.getFileType() > 1) {
                WebProjectNode n = this.getProjectRoot(source.getModel());
                if (n != null) {
                    n.invalidate();
                }
                return;
            }
            if ("FileSystems".equals(entity3)) {
                this.invalidateTagLibs(source.getModel());
            } else if ("JSFManagedBeans".equals(entity3) || "JSFManagedBeans20".equals(entity3)) {
                this.invalidateFolder(source.getModel(), "Beans");
            } else if ("JSFReferencedBeans".equals(entity3)) {
                this.invalidateFolder(source.getModel(), "Beans");
            }
        } else if (event.kind() == 3 && "FileSystemJar".equals(entity = event.getModelObject().getModelEntity().getName())) {
            this.invalidateTagLibs(source.getModel());
        }
        super.structureChanged(event);
    }

    private void invalidateBundles(XModel model) {
        this.invalidateFolder(model, "Resource Bundles");
    }

    private void invalidateTagLibs(XModel model) {
        this.invalidateFolder(model, "Tag Libraries");
    }

    private void invalidateConfig(XModel model) {
        this.invalidateFolder(model, "Configuration");
        this.invalidateFolder(model, "Beans");
    }

    private void invalidateFolder(XModel model, String name) {
        WebProjectNode n = this.getProjectRoot(model);
        if (n == null) {
            return;
        }
        WebProjectNode b = (WebProjectNode)n.getChildByPath(name);
        b.invalidate();
    }
}

