/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.ui.test;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.seam.config.ui.test.ContentAssistantTestCase;
import org.jboss.tools.test.util.ResourcesUtils;

public class SeamConfigContentAssistTest
extends ContentAssistantTestCase {
    protected static String PLUGIN_ID = "org.jboss.tools.cdi.seam.config.core.test";
    protected static String PROJECT_NAME = "CDIConfigTest";
    protected static String PROJECT_PATH = "/projects/CDIConfigTest";
    protected static String FILE_PATH = "src/META-INF/seam-beans.xml";
    protected ICDIProject cdiProject;

    public SeamConfigContentAssistTest() {
        this.project = this.getTestProject();
        this.cdiProject = CDICorePlugin.getCDIProject((IProject)this.project, (boolean)false);
    }

    public IProject getTestProject() {
        if (this.project == null) {
            try {
                this.project = SeamConfigContentAssistTest.findTestProject();
                if (this.project == null || !this.project.exists()) {
                    this.project = ResourcesUtils.importProject((String)PLUGIN_ID, (String)PROJECT_PATH);
                    this.project.build(10, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                SeamConfigContentAssistTest.fail((String)("Can't import CDI test project: " + e.getMessage()));
            }
        }
        return this.project;
    }

    public static IProject findTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }

    public void testCustomClasses() {
        String[] proposals = new String[]{"test01:MyBean1", "test01:MyBean2", "test01:MyBean3", "test01:MyBean4"};
        this.checkProposals(FILE_PATH, "<test01:", 8, proposals, true);
    }

    public void testEEClassesAndKeyWords() {
        String[] proposals = new String[]{"s:modifies"};
        this.checkProposals(FILE_PATH, "<s:mo", 5, proposals, true);
        proposals = new String[]{"s:modifies", "s:replaces", "s:parameters", "s:Inject", "s:Alternative", "s:Delegate", "s:Dependent", "s:Disposes", "s:Named", "s:New", "s:NormalScope"};
        this.checkProposals(FILE_PATH, "<s:mo", 3, proposals, false);
    }

    public void testPackageInNamespace() {
        String[] proposals = new String[]{"urn:java:org.jboss.beans.test01", "urn:java:org.jboss.beans.test02", "urn:java:org.jboss.beans.test03", "urn:java:org.jboss.beans.test04", "urn:java:org.jboss.beans.test05", "urn:java:org.jboss.beans.test06"};
        String text = "urn:java:org.jboss.beans.";
        this.checkProposals(FILE_PATH, text, text.length(), proposals, false);
    }
}

