/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.scanner.BatchArchiveDetector;
import org.jboss.tools.foundation.core.plugin.BaseCorePlugin;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.osgi.framework.BundleContext;

public class BatchCorePlugin
extends BaseCorePlugin {
    public static String PLUGIN_ID = "org.jboss.tools.batch.core";
    static BatchCorePlugin plugin = null;

    public BatchCorePlugin() {
        plugin = this;
    }

    public static BatchCorePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, new ISaveParticipant(){

            public void saving(ISaveContext context) throws CoreException {
                BatchArchiveDetector.getInstance().save();
            }

            public void rollback(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void doneSaving(ISaveContext context) {
            }
        });
    }

    public static IPluginLog pluginLog() {
        return BatchCorePlugin.getDefault().pluginLogInternal();
    }

    public static IBatchProject getBatchProject(IProject project, boolean resolve) {
        BatchProject result = BatchProjectFactory.getBatchProject(project, resolve);
        return result != null && result.exists() ? result : null;
    }
}

