/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.internal.core.impl.definition.BatchXMLDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.BeanUtil;

public class BatchArtifact
implements IBatchArtifact {
    BatchProject project;
    TypeDefinition definition;
    String name;
    List<IBatchProperty> properties = new ArrayList<IBatchProperty>();
    Map<String, IBatchProperty> propertiesByName = new HashMap<String, IBatchProperty>();
    Map<String, IBatchProperty> propertiesByFieldName = new HashMap<String, IBatchProperty>();

    public void setProject(BatchProject project) {
        this.project = project;
    }

    public void setDefinition(TypeDefinition def) {
        this.definition = def;
        this.initName();
        List<FieldDefinition> fs = def.getFields();
        for (FieldDefinition f : fs) {
            BatchProperty p = new BatchProperty();
            p.setArtifact(this);
            p.setDefinition(f);
            this.properties.add(p);
            this.propertiesByName.put(p.getPropertyName(), p);
            this.propertiesByFieldName.put(p.getField().getElementName(), p);
        }
    }

    void initName() {
        if (this.definition.getNamedAnnotation() != null) {
            Object v = this.definition.getNamedAnnotation().getMemberValue(null, true);
            this.name = v != null ? v.toString() : BeanUtil.getDefaultBeanName((IType)this.definition.getType());
        } else {
            this.name = this.definition.getQualifiedName();
            for (BatchXMLDefinition def : this.getProject().getDeclaredBatchXMLDefinitions()) {
                String n = def.getArtifactName(this.definition.getQualifiedName());
                if (n == null) continue;
                this.name = n;
                break;
            }
        }
    }

    @Override
    public BatchProject getProject() {
        return this.project;
    }

    @Override
    public IPath getSourcePath() {
        return this.definition.getType().getPath();
    }

    @Override
    public BatchArtifactType getArtifactType() {
        return this.definition.getArtifactType();
    }

    @Override
    public IAnnotationDeclaration getNamedDeclaration() {
        return this.definition.getNamedAnnotation();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IType getType() {
        return this.definition.getType();
    }

    @Override
    public Collection<IBatchProperty> getProperties() {
        return this.properties;
    }

    @Override
    public IBatchProperty getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    @Override
    public IBatchProperty getProperty(IField field) {
        return this.propertiesByFieldName.get(field.getElementName());
    }

    @Override
    public Collection<ITextSourceReference> getReferences() {
        HashSet<ITextSourceReference> result = new HashSet<ITextSourceReference>();
        for (IFile file : this.project.getDeclaredBatchJobs()) {
            result.addAll(BatchUtil.getAttributeReferences(file, "ref", this.getName()));
        }
        return result;
    }
}

