/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.internal.core.impl.BatchUtil;
import org.jboss.tools.batch.internal.core.impl.DefinitionContext;
import org.jboss.tools.batch.internal.core.impl.definition.BatchJobDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.BatchXMLDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.batch.internal.core.scanner.FileSet;
import org.jboss.tools.batch.internal.core.scanner.lib.JarSet;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.internal.IIncrementalProjectBuilderExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatchBuilder
extends IncrementalProjectBuilder
implements IIncrementalProjectBuilderExtension {
    BatchResourceVisitor resourceVisitor = null;
    BatchProject batch = null;

    public BatchBuilder() {
    }

    public BatchBuilder(BatchProject batch) throws CoreException {
        this.batch = batch;
        this.build(6, null, (IProgressMonitor)new NullProgressMonitor());
    }

    protected BatchProject getBatchProject() {
        if (this.batch != null) {
            return this.batch;
        }
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return BatchProjectFactory.getBatchProject(p, false);
    }

    BatchResourceVisitor getResourceVisitor() {
        if (this.resourceVisitor == null) {
            this.resourceVisitor = new BatchResourceVisitor();
        }
        return this.resourceVisitor;
    }

    public IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.resourceVisitor = null;
        BatchProject n = this.getBatchProject();
        if (n == null) {
            return null;
        }
        if (n.getType("javax.batch.api.AbstractBatchlet") == null) {
            n.clean();
            return null;
        }
        n.getClassPath().init();
        if (n.hasNoStorage()) {
            kind = 6;
        }
        n.postponeFiring();
        try {
            n.resolveStorage(kind != 6);
            if (kind == 6) {
                n.getClassPath().reset();
            }
            boolean isClassPathUpdated = n.getClassPath().update();
            JarSet newJars = new JarSet();
            if (isClassPathUpdated || kind == 6) {
                n.getClassPath().setSrcs(this.getResourceVisitor().srcs);
                newJars = n.getClassPath().process();
            }
            n.getDefinitions().newWorkingCopy(kind == 6);
            if (isClassPathUpdated) {
                n.getClassPath().applyRemovedPaths();
            }
            if (isClassPathUpdated || kind == 6) {
                this.buildJars(newJars);
                n.getClassPath().validateProjectDependencies();
                kind = 6;
            } else if (n.getClassPath().hasToUpdateProjectDependencies()) {
                n.getClassPath().validateProjectDependencies();
            }
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getCurrentProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
            this.getBatchProject().getDefinitions().applyWorkingCopy();
            try {
                n.store();
            }
            catch (IOException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
        }
        finally {
            n.fireChanges();
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            BatchResourceVisitor rv = this.getResourceVisitor();
            rv.incremental = false;
            this.getCurrentProject().accept((IResourceVisitor)rv);
            FileSet fs = rv.fileSet;
            this.build(fs, this.getBatchProject());
        }
        catch (CoreException e) {
            BatchCorePlugin.pluginLog().logError((Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        BatchResourceVisitor rv = this.getResourceVisitor();
        rv.incremental = true;
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
        FileSet fs = rv.fileSet;
        this.build(fs, this.getBatchProject());
    }

    private void buildJars(JarSet newJars) throws CoreException {
        IJavaProject jp = EclipseUtil.getJavaProject((IProject)this.getBatchProject().getProject());
        if (jp == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles((Object)this);
            FileSet fileSet = new FileSet();
            for (String jar : newJars.getBatchModules()) {
                IJavaElement[] es;
                Path path = new Path(jar);
                IPackageFragmentRoot root = jp.getPackageFragmentRoot(jar);
                if (root == null) continue;
                if (!root.exists()) {
                    IFile f = BatchBuilder.getFile(jar);
                    if (f != null && f.exists()) {
                        root = jp.getPackageFragmentRoot((IResource)f);
                    } else {
                        f = BatchBuilder.getFile(String.valueOf(jar) + "/META-INF/web-fragment.xml");
                        if (f != null && f.exists()) {
                            root = jp.getPackageFragmentRoot((IResource)f.getParent().getParent());
                        }
                    }
                }
                if (root == null || !root.exists()) continue;
                IJavaElement[] iJavaElementArray = es = root.getChildren();
                int n = es.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement e = iJavaElementArray[n2];
                    if (e instanceof IPackageFragment) {
                        IClassFile[] cs;
                        IPackageFragment pf = (IPackageFragment)e;
                        IClassFile[] iClassFileArray = cs = pf.getClassFiles();
                        int n3 = cs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClassFile c = iClassFileArray[n4];
                            fileSet.add((IPath)path, c.getType());
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            this.build(fileSet, this.getBatchProject());
        }
        finally {
            manager.flushZipFiles((Object)this);
        }
    }

    void build(FileSet fs, BatchProject project) {
        DefinitionContext context = this.getBatchProject().getDefinitions().getWorkingCopy();
        Set<IFile> batchXMLs = fs.getBatchXMLs();
        for (IFile batchXML : batchXMLs) {
            final BatchXMLDefinition def = new BatchXMLDefinition();
            def.setFile(batchXML);
            BatchUtil.scanXMLFile(batchXML, new BatchUtil.DocumentScanner(){

                @Override
                public void scanDocument(Document document) {
                    Element element;
                    if (document != null && (element = document.getDocumentElement()) != null) {
                        Element[] elementArray = XMLUtilities.getChildren((Element)element, (String)"ref");
                        int n = elementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Element ref = elementArray[n2];
                            String id = ref.getAttribute("id");
                            String cls = ref.getAttribute("class");
                            if (id != null && id.length() > 0 && cls != null && cls.length() > 0) {
                                def.add(cls, id);
                            }
                            ++n2;
                        }
                    }
                }
            });
            context.addBatchXML(def);
        }
        Map<IPath, Set<IType>> cs = fs.getClasses();
        for (IPath f : cs.keySet()) {
            Set<IType> ts = cs.get(f);
            for (IType type : ts) {
                TypeDefinition def = new TypeDefinition();
                def.setType(type, context, 0);
                if (def.getArtifactType() == null) continue;
                context.addType(f, type.getFullyQualifiedName(), def);
            }
        }
        Set<IFile> batchJobs = fs.getBatchJobs();
        if (!batchJobs.isEmpty()) {
            for (IFile batchJob : batchJobs) {
                final BatchJobDefinition def = new BatchJobDefinition();
                def.setFile(batchJob);
                BatchUtil.scanXMLFile(batchJob, new BatchUtil.DocumentScanner(){

                    @Override
                    public void scanDocument(Document document) {
                        Element element;
                        if (document != null && (element = document.getDocumentElement()) != null) {
                            String id = element.getAttribute("id");
                            def.setJobID(id);
                        }
                    }
                });
                context.addBatchConfig(def);
            }
        }
    }

    public static IFile getFile(String location) {
        IPath path = new Path(location).makeAbsolute();
        IFile result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        return result;
    }

    IProject getCurrentProject() {
        return this.batch != null ? this.batch.getProject() : this.getProject();
    }

    Set<IFile> getDependentFiles(IPath path, Set<IPath> visited) {
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        BatchProject p = this.getBatchProject();
        if (p != null) {
            p.clean();
        }
    }

    class BatchResourceVisitor
    implements IResourceVisitor {
        boolean incremental = false;
        FileSet fileSet = new FileSet();
        IPath[] outs = new IPath[0];
        IPath[] srcs = new IPath[0];
        IPath[] batch_jobs = new IPath[0];
        IPath[] batch_xmls = new IPath[0];
        Set<IPath> visited = new HashSet<IPath>();

        public BatchResourceVisitor() {
            this.getJavaSourceRoots(BatchBuilder.this.getCurrentProject());
        }

        void getJavaSourceRoots(IProject project) {
            IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
            if (javaProject == null) {
                return;
            }
            ArrayList<IPath> ps = new ArrayList<IPath>();
            ArrayList<IPath> os = new ArrayList<IPath>();
            try {
                IPath output = javaProject.getOutputLocation();
                if (output != null) {
                    os.add(output);
                }
                IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < es.length) {
                    if (es[i].getEntryKind() == 3) {
                        IPath out;
                        IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                        if (findMember != null && findMember.exists()) {
                            ps.add(findMember.getFullPath());
                        }
                        if ((out = es[i].getOutputLocation()) != null && !os.contains(out)) {
                            os.add(out);
                        }
                    }
                    ++i;
                }
                this.srcs = ps.toArray(new IPath[0]);
                this.outs = os.toArray(new IPath[0]);
                this.batch_jobs = new IPath[this.srcs.length];
                this.batch_xmls = new IPath[this.srcs.length];
                i = 0;
                while (i < this.srcs.length) {
                    IPath b = this.srcs[i].append("META-INF/batch-jobs");
                    IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(b);
                    if (findMember != null && findMember.exists()) {
                        this.batch_jobs[i] = findMember.getFullPath();
                    }
                    IPath x = this.srcs[i].append("META-INF/batch.xml");
                    findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(x);
                    if (findMember != null && findMember.exists()) {
                        this.batch_xmls[i] = findMember.getFullPath();
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                BatchCorePlugin.pluginLog().logError("Error while locating java source roots for " + project, (Throwable)ce);
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath path = resource.getFullPath();
            if (resource instanceof IFile) {
                if (this.visited.contains(path)) {
                    return false;
                }
                this.visited.add(path);
                IFile f = (IFile)resource;
                int i = 0;
                while (i < this.outs.length) {
                    if (this.outs[i].isPrefixOf(path)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.srcs.length) {
                    if (this.batch_jobs[i] != null && this.batch_jobs[i].isPrefixOf(path)) {
                        if (f.getName().toLowerCase().endsWith(".xml")) {
                            this.fileSet.addBatchJob(f);
                        }
                    } else if (this.batch_xmls[i] != null && this.batch_xmls[i].equals((Object)path)) {
                        this.fileSet.addBatchXML(f);
                    } else if (this.srcs[i].isPrefixOf(path)) {
                        Set<IFile> ds;
                        ICompilationUnit unit;
                        if (f.getName().toLowerCase().endsWith(".java") && (unit = EclipseUtil.getCompilationUnit((IFile)f)) != null) {
                            this.fileSet.add(f.getFullPath(), unit.getTypes());
                        }
                        if ((ds = BatchBuilder.this.getDependentFiles(path, this.visited)) != null) {
                            for (IFile d : ds) {
                                this.visit((IResource)d);
                            }
                        }
                        return false;
                    }
                    ++i;
                }
                Set<IFile> ds = BatchBuilder.this.getDependentFiles(path, this.visited);
                if (ds != null) {
                    for (IFile d : ds) {
                        this.visit((IResource)d);
                    }
                }
            } else if (resource instanceof IFolder) {
                int i = 0;
                while (i < this.outs.length) {
                    if (this.outs[i].isPrefixOf(path)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.srcs.length) {
                    if (this.srcs[i].isPrefixOf(path) || path.isPrefixOf(this.srcs[i])) {
                        return true;
                    }
                    ++i;
                }
                return resource == resource.getProject();
            }
            return true;
        }
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return BatchBuilder.this.getResourceVisitor().visit(resource);
                }
                case 2: {
                    BatchProject p = BatchBuilder.this.getBatchProject();
                    if (p == null) break;
                    p.getDefinitions().getWorkingCopy().clean(resource.getFullPath());
                    break;
                }
                case 4: {
                    return BatchBuilder.this.getResourceVisitor().visit(resource);
                }
            }
            return true;
        }
    }
}

